/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ads;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.drivers.ads.Notification;
import org.lsst.ccs.drivers.ads.VarHandleTracker;
import org.lsst.ccs.drivers.ads.VariableHandle;
import org.lsst.ccs.drivers.ads.wrapper.ADSLibrary;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationAttrib;
import org.lsst.ccs.drivers.ads.wrapper.AdsNotificationHeader;
import org.lsst.ccs.drivers.ads.wrapper.AmsAddr;
import org.lsst.ccs.drivers.ads.wrapper.AmsNetId;
import org.lsst.ccs.drivers.ads.wrapper.PAdsNotificationFuncEx;
import org.lsst.ccs.drivers.commons.DriverException;

public class ADSDriver {
    public static final int NOTIFICATION_QUEUE_SIZE = 1000;
    private final ADSLibrary ADS;
    private final AmsNetId localNetId;
    private final long localPort;
    private final PAdsNotificationFuncEx notificationCallback;
    private final BlockingQueue<Notification> notificationQueue;
    private final VarHandleTracker vhTracker;
    private AmsAddr remoteAddr;
    private static final Pattern NETID_PATTERN = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)\\.1\\.1");
    private static final Set<Long> LOST_COMM_STATUS = new TreeSet<Long>();

    public ADSDriver(String localAMSNetId) throws DriverException {
        this(localAMSNetId, Native.loadLibrary("AdsJNA", ADSLibrary.class));
    }

    ADSDriver(String localAMSNetId, ADSLibrary ADS) throws DriverException {
        this.ADS = ADS;
        this.localNetId = ADSDriver.decodeNetId(localAMSNetId);
        ADS.AdsSetLocalAddress(this.localNetId);
        this.localPort = ADS.AdsPortOpenEx();
        if (this.localPort == 0L) {
            throw new InitializationException("Failed to create a new local ADS port.");
        }
        this.notificationCallback = this::notificationHandler;
        this.notificationQueue = new ArrayBlockingQueue<Notification>(1000);
        this.remoteAddr = null;
        this.vhTracker = new VarHandleTracker();
    }

    public synchronized void open(String remoteAMSNetId, String remoteIPv4) throws DriverException {
        if (this.remoteAddr != null) {
            this.close();
        }
        this.remoteAddr = new AmsAddr(ADSDriver.decodeNetId(remoteAMSNetId), 851);
        this.checkStatus(this.ADS.AdsAddRoute(this.remoteAddr.netId, remoteIPv4), "Couldn't connect to the controller.", OpenException.class);
    }

    public synchronized void close() {
        if (this.remoteAddr != null) {
            this.ADS.AdsDelRoute(this.remoteAddr.netId);
        }
        this.remoteAddr = null;
        this.vhTracker.clear();
        this.notificationQueue.clear();
    }

    public synchronized VariableHandle getVariableHandle(String varName) throws DriverException {
        this.checkOpen();
        VariableHandle vh = this.vhTracker.getByName(varName);
        if (vh != null) {
            return vh;
        }
        ByteBuffer wbuf = ADSDriver.makeByteBuffer("MAIN." + varName);
        ByteBuffer rbuf = ADSDriver.makeByteBuffer(4);
        long handleStatus = this.ADS.AdsSyncReadWriteReqEx2(this.localPort, this.remoteAddr, 61443, 0, rbuf.capacity(), rbuf.array(), wbuf.capacity(), wbuf.array(), null);
        this.checkStatus(handleStatus, "Creation of a variable handle failed.", LookupException.class);
        int handleValue = rbuf.getInt();
        rbuf = ADSDriver.makeByteBuffer(12);
        long status = this.ADS.AdsSyncReadWriteReqEx2(this.localPort, this.remoteAddr, 61447, 0, rbuf.capacity(), rbuf.array(), wbuf.capacity(), wbuf.array(), null);
        this.checkStatus(status, "Reading of symbol info failed.", LookupException.class);
        int varSize = rbuf.getInt(8);
        vh = new VariableHandle(handleValue, varName, varSize);
        this.vhTracker.add(vh);
        return vh;
    }

    public synchronized void releaseVariableHandle(VariableHandle varHandle) throws DriverException {
        this.checkOpen();
        this.checkVarHandle(varHandle);
        ByteBuffer wbuf = ADSDriver.makeByteBuffer(4);
        wbuf.putInt(varHandle.getHandleValue());
        long status = this.ADS.AdsSyncWriteReqEx(this.localPort, this.remoteAddr, 61446, 0, wbuf.capacity(), wbuf.array());
        this.checkStatus(status, "Releasing the variable handle failed.", BadVarHandleException.class);
        this.cancelNotifications(varHandle);
        this.vhTracker.remove(varHandle);
    }

    public synchronized int requestNotifications(VariableHandle varHandle, Duration maxDelay, Duration checkInterval, boolean onlyIfChanged) throws DriverException {
        this.checkOpen();
        this.checkVarHandle(varHandle);
        Integer oldHandle = this.vhTracker.getNotification(varHandle);
        if (oldHandle != null) {
            return oldHandle;
        }
        AdsNotificationAttrib attrib = new AdsNotificationAttrib(varHandle.getVarSize(), onlyIfChanged ? 4 : 3, (int)maxDelay.toNanos() / 100, (int)checkInterval.toNanos() / 100);
        int[] hNotify = new int[]{0};
        boolean hUser = false;
        long addStatus = this.ADS.AdsSyncAddDeviceNotificationReqEx(this.localPort, this.remoteAddr, 61445, varHandle.getHandleValue(), attrib, this.notificationCallback, 0, hNotify);
        this.checkStatus(addStatus, "The request for notifications failed.", NotificationException.class);
        this.vhTracker.addNotification(varHandle, hNotify[0]);
        return hNotify[0];
    }

    public synchronized void cancelNotifications(VariableHandle varHandle) throws DriverException {
        this.checkOpen();
        this.checkVarHandle(varHandle);
        Integer nh = this.vhTracker.removeNotification(varHandle);
        if (nh != null) {
            long status = this.ADS.AdsSyncDelDeviceNotificationReqEx(this.localPort, this.remoteAddr, nh);
            this.checkStatus(status, "Canceling notifications failed.", NotificationException.class);
        }
    }

    public synchronized ByteBuffer readVariable(VariableHandle varHandle) throws DriverException {
        this.checkOpen();
        this.checkVarHandle(varHandle);
        ByteBuffer rbuf = ADSDriver.makeByteBuffer(varHandle.getVarSize());
        long status = this.ADS.AdsSyncReadReqEx2(this.localPort, this.remoteAddr, 61445, varHandle.getHandleValue(), rbuf.capacity(), rbuf.array(), null);
        this.checkStatus(status, "Reading a variable value failed.", ReadWriteException.class);
        return rbuf;
    }

    public synchronized void writeVariable(VariableHandle varHandle, ByteBuffer wbuf) throws DriverException {
        this.checkOpen();
        this.checkVarHandle(varHandle);
        if (wbuf.capacity() != varHandle.getVarSize()) {
            throw new ReadWriteException("wbuf.capacity() != variable size.");
        }
        long status = this.ADS.AdsSyncWriteReqEx(this.localPort, this.remoteAddr, 61445, varHandle.getHandleValue(), wbuf.capacity(), wbuf.array());
        this.checkStatus(status, "Writing a variable value failed.", ReadWriteException.class);
    }

    public Notification takeNotification() throws InterruptedException {
        return this.notificationQueue.take();
    }

    public Notification pollNotification() {
        return (Notification)this.notificationQueue.poll();
    }

    public Notification pollNotification(long timeout, TimeUnit unit) throws InterruptedException {
        return this.notificationQueue.poll(timeout, unit);
    }

    public int drainNotifications(Collection<Notification> collectn) {
        return this.notificationQueue.drainTo(collectn);
    }

    public int drainNotifications(Collection<Notification> collectn, int maxElements) {
        return this.notificationQueue.drainTo(collectn, maxElements);
    }

    private static ByteBuffer makeByteBuffer(int size) {
        return ADSDriver.makeByteBuffer(new byte[size]);
    }

    private static ByteBuffer makeByteBuffer(byte[] array) {
        return ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN);
    }

    private static ByteBuffer makeByteBuffer(String name) {
        return ADSDriver.makeByteBuffer(name.getBytes(StandardCharsets.US_ASCII));
    }

    private static AmsNetId decodeNetId(String id) throws DriverException {
        Matcher mat = NETID_PATTERN.matcher(id);
        if (mat.matches()) {
            return new AmsNetId((byte)Integer.parseInt(mat.group(1)), (byte)Integer.parseInt(mat.group(2)), (byte)Integer.parseInt(mat.group(3)), (byte)Integer.parseInt(mat.group(4)), 1, 1);
        }
        throw new DriverException("Ill-formed AMS NetId.");
    }

    private void notificationHandler(AmsAddr addr, AdsNotificationHeader header, int hUser) {
        Pointer bufptr = header.getPointer();
        ByteBuffer data = ByteBuffer.wrap(bufptr.getByteArray(AdsNotificationHeader.headerSize(), header.cbSampleSize)).asReadOnlyBuffer().order(ByteOrder.LITTLE_ENDIAN);
        VariableHandle varHandle = this.vhTracker.getByNotification(header.hNotification);
        Notification notice = new Notification(header.hNotification, varHandle, data);
        try {
            this.notificationQueue.put(notice);
        }
        catch (InterruptedException exc) {
            Thread.currentThread().interrupt();
        }
    }

    private void checkOpen() throws DriverException {
        if (this.remoteAddr == null) {
            throw new NotOpenException("open() hasn't been called.");
        }
    }

    private void checkVarHandle(VariableHandle varHandle) throws DriverException {
        if (!this.vhTracker.isValid(varHandle)) {
            throw new BadVarHandleException("That variable handle was released and is no longer valid.");
        }
    }

    private void checkStatus(long status, String msg, Class<?> klass) throws DriverException {
        if (status != 0L) {
            String codeMsg = String.format("%s Error code 0x%04x.", msg, status);
            if (LOST_COMM_STATUS.contains(status)) {
                throw new LostContactException(codeMsg);
            }
            try {
                throw (DriverException)klass.getConstructor(String.class).newInstance(codeMsg);
            }
            catch (ReflectiveOperationException exc) {
                throw new DriverException("BUG - can't create the right kind of exception.", (Throwable)exc);
            }
        }
    }

    static {
        LOST_COMM_STATUS.add(6L);
        LOST_COMM_STATUS.add(13L);
        LOST_COMM_STATUS.add(18L);
        LOST_COMM_STATUS.add(26L);
        LOST_COMM_STATUS.add(27L);
        LOST_COMM_STATUS.add(10060L);
        LOST_COMM_STATUS.add(10061L);
        LOST_COMM_STATUS.add(1864L);
    }

    public static class ReadWriteException
    extends DriverException {
        public ReadWriteException(String message) {
            super(message);
        }
    }

    public static class NotificationException
    extends DriverException {
        public NotificationException(String message) {
            super(message);
        }
    }

    public static class BadVarHandleException
    extends DriverException {
        public BadVarHandleException(String message) {
            super(message);
        }
    }

    public static class LookupException
    extends DriverException {
        public LookupException(String message) {
            super(message);
        }
    }

    public static class LostContactException
    extends DriverException {
        public LostContactException(String message) {
            super(message);
        }
    }

    public static class OpenException
    extends DriverException {
        public OpenException(String message) {
            super(message);
        }
    }

    public static class NotOpenException
    extends DriverException {
        public NotOpenException(String message) {
            super(message);
        }
    }

    public static class InitializationException
    extends DriverException {
        public InitializationException(String message) {
            super(message);
        }
    }
}

