/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.time.Duration;
import java.util.EnumSet;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.lsst.ccs.subsystem.shutter.common.PLCError;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.MotionDonePLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Context;
import org.lsst.ccs.subsystem.shutter.statemachine.DummyChannel;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleContext;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;
import org.mockito.Mockito;

public class SimpleStateTest {
    private static final SimpleContext<?> DUMMY_CONTEXT = (SimpleContext)Mockito.mock(SimpleContext.class);
    private final TestState stateObj = new TestState();

    @Test
    public void testGetContext() {
        Assertions.assertEquals(DUMMY_CONTEXT, (Object)this.stateObj.getContext(), (String)"Wrong context retrieved.");
    }

    @Test
    public void testRejection() throws InterruptedException {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.contactLost(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event contactLost() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.plcIsEnabled(chan);
            EventReply reply = (EventReply)chan.read();
            Assertions.assertTrue((boolean)reply.wasAccepted(null), (String)"plcIsEnabled() should have been accepted.");
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.plcIsDisabled(chan);
            EventReply reply = (EventReply)chan.read();
            Assertions.assertTrue((boolean)reply.wasAccepted(null), (String)"plcIsDisabled() should have been accepted.");
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.resync(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event resync() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.syncTimeout(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event syncTimeout() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.enable(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event enable() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.disable(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event disable() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.motionDone(chan, new MotionDonePLC(1, null));
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event motionDone() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.calibrate(chan, new Calibrate());
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event calibrate() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.calibDone(chan, new CalibDone(1, new double[]{0.0, 0.0}, new double[]{0.0, 0.0}, () -> 0.0));
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event calibDone() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.error(chan, new Error(0, EnumSet.noneOf(PLCError.class)));
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event error() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.reset(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event reset() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.takeExposure(chan, Duration.ZERO);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event takeExposure() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.openShutter(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event openShutter() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.timer(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event timer() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.closeShutter(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event closeShutter() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.ignored(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event ignored() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.gotoProd(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Can't go to Prod from CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.gotoCenter(chan);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event gotoCenter() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.moveAxisAbsolute(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event moveAxisAbsolute() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.moveAxisRelative(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event moveAxisRelative() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.clearAllFaults(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event clearAllFaults() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.changeAxisEnable(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event changeAxisEnable() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.clearAxisFaults(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event clearAxisFaults() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.enableAllAxes(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event enableAllAxes() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }, () -> {
            DummyChannel chan = new DummyChannel();
            this.stateObj.disableAllAxes(chan, null);
            EventReply reply = (EventReply)chan.read();
            reply.wasAccepted(null);
            Assertions.assertEquals((Object)"Event disableAllAxes() is invalid for CCS state TestState.", (Object)reply.getMessage());
        }});
    }

    private static class TestState
    extends SimpleState<SimpleContext<?>> {
        public TestState() {
            super((Context)DUMMY_CONTEXT);
        }

        public Logger getLogger() {
            return null;
        }
    }
}

