/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.shutter.Controller;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.plc.BladeSetPosition;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class ShutterInfoTest {
    private static Map<String, Double> PLUS_X_CONFIG;
    private static Map<String, Double> MINUS_X_CONFIG;
    private static final int SCURVE_PROFILE = 0;
    private static final int PLC_STILL = 21010;
    private static final double BLADE_SET_VELOCITY = 0.0;
    private static final double BLADE_SET_ACCELERATION = 0.0;
    private static final int NO_ERROR = 0;
    private static final double MOTOR_TEMP = 30.0;
    private static boolean calibFlag;
    private static double plusActPos;
    private static boolean plusEnabled;
    private static boolean plusBrakeEngaged;
    private static boolean plusLowLimit;
    private static boolean plusHighLimit;
    private static boolean plusHomed;
    private static double minusActPos;
    private static boolean minusEnabled;
    private static boolean minusBrakeEngaged;
    private static boolean minusLowLimit;
    private static boolean minusHighLimit;
    private static boolean minusHomed;

    @BeforeEach
    public void resetStatusFields() {
        calibFlag = true;
        plusActPos = PLUS_X_CONFIG.get(BladeSetPosition.RETRACTED.getKey()) - 0.5;
        plusEnabled = true;
        plusBrakeEngaged = false;
        plusLowLimit = false;
        plusHighLimit = false;
        plusHomed = true;
        minusActPos = MINUS_X_CONFIG.get(BladeSetPosition.EXTENDED.getKey()) - 0.5;
        minusEnabled = true;
        minusBrakeEngaged = false;
        minusLowLimit = false;
        minusHighLimit = false;
        minusHomed = true;
    }

    private Controller.ShutterInfo makeInfo() {
        ShutterStatus.AxisStatus plusAxis = new ShutterStatus.AxisStatus(plusActPos, 0.0, 0.0, plusEnabled, plusBrakeEngaged, plusLowLimit, plusHighLimit, plusHomed, 0, 30.0);
        ShutterStatus.AxisStatus minusAxis = new ShutterStatus.AxisStatus(minusActPos, 0.0, 0.0, minusEnabled, minusBrakeEngaged, minusLowLimit, minusHighLimit, minusHomed, 0, 30.0);
        HashMap<ShutterSide, ShutterStatus.AxisStatus> axisMap = new HashMap<ShutterSide, ShutterStatus.AxisStatus>();
        axisMap.put(ShutterSide.PLUSX, plusAxis);
        axisMap.put(ShutterSide.MINUSX, minusAxis);
        ShutterStatus status = new ShutterStatus(0, calibFlag, 21010, axisMap);
        return new Controller.ShutterInfo(status, MINUS_X_CONFIG, PLUS_X_CONFIG);
    }

    @Test
    public void testShutterIsReady1() {
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNull((Object)msg);
    }

    @Test
    public void testShutterIsReady2() {
        calibFlag = false;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertTrue((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady3() {
        plusEnabled = false;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertTrue((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady4() {
        minusEnabled = false;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertTrue((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady5() {
        plusHomed = false;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertTrue((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady6() {
        minusHomed = false;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertTrue((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady7() {
        plusBrakeEngaged = true;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertTrue((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady8() {
        minusBrakeEngaged = true;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertTrue((boolean)msg.contains("brake"));
        Assertions.assertFalse((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady9() {
        minusActPos = MINUS_X_CONFIG.get(BladeSetPosition.CENTERED.getKey());
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertTrue((boolean)msg.contains("closed"));
    }

    @Test
    public void testShutterIsReady10() {
        plusActPos = PLUS_X_CONFIG.get(BladeSetPosition.EXTENDED.getKey()) + 0.5;
        minusActPos = MINUS_X_CONFIG.get(BladeSetPosition.RETRACTED.getKey()) + 0.5;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNull((Object)msg);
    }

    @Test
    public void testShutterIsReady11() {
        plusActPos = PLUS_X_CONFIG.get(BladeSetPosition.CENTERED.getKey()) + 0.5;
        minusActPos = MINUS_X_CONFIG.get(BladeSetPosition.RETRACTED.getKey()) + 0.5;
        String msg = this.makeInfo().shutterIsReady();
        Assertions.assertNotNull((Object)msg);
        Assertions.assertFalse((boolean)msg.contains("calibrated"));
        Assertions.assertFalse((boolean)msg.contains("disabled"));
        Assertions.assertFalse((boolean)msg.contains("homed"));
        Assertions.assertFalse((boolean)msg.contains("brake"));
        Assertions.assertTrue((boolean)msg.contains("closed"));
    }

    static {
        HashMap<String, Double> plus = new HashMap<String, Double>();
        plus.put(BladeSetPosition.HOME.getKey(), 0.0);
        plus.put(BladeSetPosition.RETRACTED.getKey(), 1.0);
        plus.put(BladeSetPosition.CENTERED.getKey(), 275.0);
        plus.put(BladeSetPosition.EXTENDED.getKey(), 749.0);
        PLUS_X_CONFIG = Collections.unmodifiableMap(plus);
        HashMap<String, Double> minus = new HashMap<String, Double>();
        minus.put(BladeSetPosition.HOME.getKey(), 751.0);
        minus.put(BladeSetPosition.RETRACTED.getKey(), 749.0);
        minus.put(BladeSetPosition.CENTERED.getKey(), 475.0);
        minus.put(BladeSetPosition.EXTENDED.getKey(), 1.0);
        MINUS_X_CONFIG = Collections.unmodifiableMap(minus);
    }
}

