/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.plc.MotionDone;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;
import org.lsst.ccs.subsystem.shutter.statemachine.Logging;
import org.lsst.ccs.subsystem.shutter.statemachine.PhysicalState;
import org.lsst.ccs.subsystem.shutter.statemachine.Prod;
import org.lsst.ccs.subsystem.shutter.statemachine.PromptReply;
import org.lsst.ccs.subsystem.shutter.statemachine.SimpleState;

class Opening
extends SimpleState<Prod> {
    private static final Logger LOG = Logger.getLogger(Opening.class.getName());

    public Opening(Prod context) {
        super(context);
    }

    @Override
    public Logger getLogger() {
        return LOG;
    }

    @Override
    public void entry() {
        Logging.logEntry(this);
        ((Prod)this.getContext()).getActions().setPhysicalState(PhysicalState.OPENING);
    }

    @Override
    public EventReply timer() {
        Logging.logEvent(this);
        Prod ctx = (Prod)this.getContext();
        ctx.makeTransition(ctx.getTravelingState(), null);
        return PromptReply.ACCEPTED;
    }

    @Override
    public EventReply motionDone(MotionDone profileData) {
        Logging.logEvent(this);
        Prod ctx = (Prod)this.getContext();
        ctx.makeTransition(ctx.getOpenedState(), () -> ctx.getActions().sendProfile(profileData));
        return PromptReply.ACCEPTED;
    }
}

