/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.statemachine;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;

public final class FutureReply
implements EventReply {
    private final CompletableFuture<EventReply> reply = new CompletableFuture();

    @Override
    public boolean wasAccepted() throws InterruptedException {
        try {
            return this.reply.get().wasAccepted();
        }
        catch (ExecutionException exc) {
            return false;
        }
    }

    @Override
    public String getMessage() {
        if (!this.reply.isDone()) {
            throw new IllegalStateException("Didn't wait for completion with wasAccepted().");
        }
        try {
            return this.reply.get().getMessage();
        }
        catch (InterruptedException | ExecutionException exc) {
            return null;
        }
    }

    public void put(EventReply value) {
        if (!this.reply.complete(Objects.requireNonNull(value, "Argument mustn't be null."))) {
            throw new IllegalStateException("put() was already called for this instance of FutureReply.");
        }
    }

    public String toString() {
        if (this.reply.isDone()) {
            try {
                return "FutureReply{" + this.reply.get() + '}';
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        return "FutureReply{}";
    }
}

