/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.util.Arrays;

public enum Axis {
    AXIS1("+X", 1, true),
    AXIS2("-X", 2, false);

    private String name;
    private int plcAxisNum;
    private boolean plusXside;

    private Axis(String name, int plcAxisNum, boolean plusXside) {
        this.name = name;
        this.plcAxisNum = plcAxisNum;
        this.plusXside = plusXside;
    }

    public String getName() {
        return this.name;
    }

    public int getPLCAxisNum() {
        return this.plcAxisNum;
    }

    public static Axis fromName(String name) {
        return Arrays.stream(Axis.values()).filter(ax -> ax.getName().equals(name)).findFirst().get();
    }

    public static Axis fromAxisNum(int axnum) {
        return Arrays.stream(Axis.values()).filter(ax -> ax.getPLCAxisNum() == axnum).findFirst().get();
    }

    public boolean isPlusXSide() {
        return this.plusXside;
    }

    public static Axis getPlusXSide() {
        return AXIS1.isPlusXSide() ? AXIS1 : AXIS2;
    }

    public static Axis getMinusXSide() {
        return AXIS1.isPlusXSide() ? AXIS2 : AXIS1;
    }
}

