/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.time.Duration;
import java.util.logging.Level;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.shutter.StateMachine;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.MotionDone;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.statemachine.Actions;
import org.lsst.ccs.subsystem.shutter.statemachine.PhysicalState;
import org.lsst.ccs.utilities.logging.Logger;

public class SimulatedActions
implements Actions {
    private static final Logger LOG = Logger.getLogger((String)SimulatedActions.class.getName());
    private static final Alert SYNC_ALERT = new Alert("SYNC", "Status of tracking of controller state.");
    private final StateMachine machine;
    private final Subsystem subsys;

    public SimulatedActions(StateMachine machine, Subsystem subsys) {
        this.machine = machine;
        this.subsys = subsys;
    }

    @Override
    public void cancelSyncTimer() {
        LOG.info((Object)"{ACTION cancelSyncTimer()}");
    }

    @Override
    public boolean isBadExposureTime(Duration exposureTime) {
        LOG.info((Object)"{ACTION isBadExposure()}");
        return false;
    }

    @Override
    public void lowerSyncAlert() {
        LOG.info((Object)"{ACTION lowerSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.NOMINAL, "OK.");
    }

    @Override
    public boolean makePartialContact() {
        LOG.info((Object)"{ACTION makePartialContact()}");
        return true;
    }

    @Override
    public boolean makeFullContact() {
        LOG.info((Object)"{ACTION makeFullContact()}");
        return true;
    }

    @Override
    public void setPhysicalState(PhysicalState newState) {
        LOG.log(Level.FINE, "{ACTION setPhysicalState({0})}", (Object)newState);
        this.machine.setPhysicalState(newState);
    }

    @Override
    public void raiseSyncAlert() {
        LOG.info((Object)"{ACTION raiseSyncAlert()}");
        ((AlertService)this.subsys.getAgentService(AlertService.class)).raiseAlert(SYNC_ALERT, AlertState.ALARM, "Lost track.");
    }

    @Override
    public boolean readyForCalibration() {
        LOG.info((Object)"{ACTION readyForCalibration()}");
        return true;
    }

    @Override
    public void resetPLC() {
        LOG.info((Object)"{ACTION resetPLC()}");
    }

    @Override
    public void relay(MsgToPLC eventMsg) {
        LOG.log(Level.INFO, "{ACTION relay({0}}", eventMsg.getClass());
    }

    @Override
    public void saveCalib(CalibDone cal) {
        LOG.info((Object)"{ACTION saveCalib() - not yet implemented.}");
    }

    @Override
    public void sendProfile(MotionDone mot) {
        LOG.info((Object)"{ACTION sendProfile() - not yet implemented.}");
    }

    @Override
    public void startFirstCentering() {
        LOG.info((Object)"{ACTION startFirstCentering()}");
    }

    @Override
    public void startSecondCentering() {
        LOG.info((Object)"{ACTION startSecondCentering(};}");
    }

    @Override
    public boolean shutterIsReady() {
        LOG.info((Object)"{ACTION shutterIsReady()}");
        return true;
    }

    @Override
    public void startSyncTimer() {
        LOG.info((Object)"{ACTION startSyncTimer()}");
    }

    @Override
    public void terminateContact() {
        LOG.info((Object)"{ACTION terminateContact()}");
    }
}

