/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.stream.DoubleStream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.lsst.ccs.subsystem.motorplatform.bus.ChangeAxisEnable;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAxisFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.DisableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.HomeAxis;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisAbsolute;
import org.lsst.ccs.subsystem.motorplatform.bus.MoveAxisRelative;
import org.lsst.ccs.subsystem.shutter.plc.Axis;
import org.lsst.ccs.subsystem.shutter.plc.AxisStatus;
import org.lsst.ccs.subsystem.shutter.plc.CalibDone;
import org.lsst.ccs.subsystem.shutter.plc.Calibrate;
import org.lsst.ccs.subsystem.shutter.plc.ChangeAxisEnablePLC;
import org.lsst.ccs.subsystem.shutter.plc.ChangeBrakeState;
import org.lsst.ccs.subsystem.shutter.plc.ClearAllFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.ClearAxisFaultsPLC;
import org.lsst.ccs.subsystem.shutter.plc.CloseShutter;
import org.lsst.ccs.subsystem.shutter.plc.Disable;
import org.lsst.ccs.subsystem.shutter.plc.DisableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Enable;
import org.lsst.ccs.subsystem.shutter.plc.EnableAllAxesPLC;
import org.lsst.ccs.subsystem.shutter.plc.Error;
import org.lsst.ccs.subsystem.shutter.plc.HomeAxisPLC;
import org.lsst.ccs.subsystem.shutter.plc.Ignored;
import org.lsst.ccs.subsystem.shutter.plc.MotionDone;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisAbsolutePLC;
import org.lsst.ccs.subsystem.shutter.plc.MoveAxisRelativePLC;
import org.lsst.ccs.subsystem.shutter.plc.OpenShutter;
import org.lsst.ccs.subsystem.shutter.plc.Reset;
import org.lsst.ccs.subsystem.shutter.plc.ShutterStatus;
import org.lsst.ccs.subsystem.shutter.plc.TakeExposure;
import org.lsst.ccs.subsystem.shutter.plc.Timer;

public class codingConsistencyTest {
    private static final int BIG_ENOUGH_BUFFER_SIZE = 10240;
    private static final ByteBuffer buf = ByteBuffer.allocate(10240);

    @BeforeEach
    private void setup() {
        buf.limit(buf.capacity());
        buf.rewind();
    }

    @AfterEach
    private void teardown() {
        Assertions.assertFalse((boolean)buf.hasRemaining(), (String)"Buffer has leftover data.");
    }

    @Test
    public void testCalibDone() {
        PrimitiveIterator.OfDouble supplier = DoubleStream.iterate(0.0, x -> x + 1.0).iterator();
        CalibDone msg = new CalibDone(123, () -> (Double)supplier.next());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        CalibDone msg2 = new CalibDone(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testCalibrate() {
        Calibrate msg = new Calibrate();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Calibrate msg2 = new Calibrate(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testChangeAxisEnablePLC() {
        ChangeAxisEnablePLC msg = new ChangeAxisEnablePLC(new ChangeAxisEnable("+X", true));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ChangeAxisEnablePLC msg2 = new ChangeAxisEnablePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testChangeBrakeState() {
        ChangeBrakeState msg = new ChangeBrakeState(Axis.AXIS1, ChangeBrakeState.State.RELEASED);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ChangeBrakeState msg2 = new ChangeBrakeState(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testClearAllFaultsPLC() {
        ClearAllFaultsPLC msg = new ClearAllFaultsPLC(new ClearAllFaults());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ClearAllFaultsPLC msg2 = new ClearAllFaultsPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testClearAxisFaultsPLC() {
        ClearAxisFaultsPLC msg = new ClearAxisFaultsPLC(new ClearAxisFaults("+X"));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ClearAxisFaultsPLC msg2 = new ClearAxisFaultsPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testCloseShutter() {
        CloseShutter msg = new CloseShutter();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        CloseShutter msg2 = new CloseShutter(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testDisable() {
        Disable msg = new Disable(432);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Disable msg2 = new Disable(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testDisableAllAxesPLC() {
        DisableAllAxesPLC msg = new DisableAllAxesPLC(new DisableAllAxes());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        DisableAllAxesPLC msg2 = new DisableAllAxesPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testEnable() {
        Enable msg = new Enable(23);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Enable msg2 = new Enable(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testEnableAllAxesPLC() {
        EnableAllAxesPLC msg = new EnableAllAxesPLC(new EnableAllAxes());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        EnableAllAxesPLC msg2 = new EnableAllAxesPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testError() {
        Error msg = new Error(0);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Error msg2 = new Error(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testHomeAxisPLC() {
        HomeAxisPLC msg = new HomeAxisPLC(new HomeAxis("+X"));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        HomeAxisPLC msg2 = new HomeAxisPLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testIgnored() {
        Ignored msg = new Ignored(17, Ignored.Reason.WRONG_STATE);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Ignored msg2 = new Ignored(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
        Assertions.assertEquals((Object)Ignored.Reason.WRONG_STATE, (Object)msg.getReason());
    }

    @Test
    public void testMotionDone() {
        MotionDone msg = new MotionDone(104);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        MotionDone msg2 = new MotionDone(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testMoveAxisAbsolutePLC() {
        MoveAxisAbsolutePLC msg = new MoveAxisAbsolutePLC(new MoveAxisAbsolute("-X", 123.2, 15.7));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        MoveAxisAbsolutePLC msg2 = new MoveAxisAbsolutePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testMoveAxisRelativePLC() {
        MoveAxisRelativePLC msg = new MoveAxisRelativePLC(new MoveAxisRelative("+X", -15.3, Duration.ofMillis(2500L)));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        MoveAxisRelativePLC msg2 = new MoveAxisRelativePLC(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testOpenShutter() {
        OpenShutter msg = new OpenShutter();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        OpenShutter msg2 = new OpenShutter(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testReset() {
        Reset msg = new Reset();
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Reset msg2 = new Reset(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testShutterStatus() {
        AxisStatus[] axstat = new AxisStatus[]{new AxisStatus(1.1, 2.2, 3.3, true, false, true, false, true, 15, 110.0), new AxisStatus(4.4, 5.5, 6.6, false, true, false, true, false, 13, 98.6)};
        Iterator<AxisStatus> iaxstat = Arrays.asList(axstat).iterator();
        ShutterStatus msg = new ShutterStatus(1023, 1, true, 0, () -> (AxisStatus)iaxstat.next());
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        ShutterStatus msg2 = new ShutterStatus(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testTakeExposure() {
        TakeExposure msg = new TakeExposure(Duration.ofMillis(22123L));
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        TakeExposure msg2 = new TakeExposure(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }

    @Test
    public void testTimer() {
        Timer msg = new Timer(5);
        msg.encode(buf);
        buf.limit(buf.position());
        buf.rewind();
        Timer msg2 = new Timer(buf);
        Assertions.assertEquals((Object)msg.toString(), (Object)msg2.toString());
    }
}

