/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.DoubleSupplier;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import org.lsst.ccs.subsystem.shutter.plc.Axis;
import org.lsst.ccs.subsystem.shutter.plc.Direction;
import org.lsst.ccs.subsystem.shutter.plc.MsgToCCS;

public class CalibDone
extends MsgToCCS {
    private static int TRANSITION_COUNT = 240;
    private final Map<Axis, Map<Direction, double[]>> axisTransitions;

    public CalibDone(int sequence, DoubleSupplier supplier) {
        super(sequence);
        this.axisTransitions = CalibDone.makeTransitionMap(supplier);
    }

    public CalibDone(ByteBuffer data) {
        super(data);
        DoubleSupplier supplier = () -> data.getDouble();
        this.axisTransitions = CalibDone.makeTransitionMap(supplier);
    }

    private static Map<Axis, Map<Direction, double[]>> makeTransitionMap(DoubleSupplier supplier) {
        EnumMap<Axis, Map<Direction, double[]>> axisTransitions = new EnumMap<Axis, Map<Direction, double[]>>(Axis.class);
        for (Axis ax : Axis.values()) {
            EnumMap<Direction, double[]> directions = new EnumMap<Direction, double[]>(Direction.class);
            for (Direction di : Direction.values()) {
                double[] trans = new double[TRANSITION_COUNT];
                for (int i = 0; i < trans.length; ++i) {
                    trans[i] = supplier.getAsDouble();
                }
                directions.put(di, trans);
            }
            axisTransitions.put(ax, directions);
        }
        return axisTransitions;
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        for (Axis ax : Axis.values()) {
            for (Direction di : Direction.values()) {
                double[] trans = this.getHallTransitions(ax, di);
                for (int i = 0; i < trans.length; ++i) {
                    data.putDouble(trans[i]);
                }
            }
        }
    }

    public double[] getHallTransitions(Axis axis, Direction direction) {
        return this.axisTransitions.get((Object)axis).get((Object)direction);
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer("CalibDone{" + super.toString());
        for (Axis ax : Axis.values()) {
            for (Direction di : Direction.values()) {
                DoubleStream pos = Arrays.stream(this.getHallTransitions(ax, di));
                buf.append(", transitions[");
                buf.append((Object)ax);
                buf.append("][");
                buf.append((Object)di);
                buf.append("]={");
                buf.append(pos.mapToObj(Double::toString).collect(Collectors.joining(", ")));
                buf.append("}");
            }
        }
        buf.append("}");
        return buf.toString();
    }
}

