/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.lsst.ccs.subsystem.shutter.plc.Axis;
import org.lsst.ccs.subsystem.shutter.plc.AxisStatus;
import org.lsst.ccs.subsystem.shutter.plc.PLCMsg;
import org.lsst.ccs.subsystem.shutter.plc.Tools;

public class ShutterStatus
extends PLCMsg
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int motionProfile;
    private final boolean isCalibrated;
    private final int smState;
    private final Map<Axis, AxisStatus> axstatus;

    public ShutterStatus(int motionProfile, boolean isCalibrated, int smState, Supplier<AxisStatus> axes) {
        this.motionProfile = motionProfile;
        this.isCalibrated = isCalibrated;
        this.smState = smState;
        this.axstatus = new EnumMap<Axis, AxisStatus>(Axis.class);
        for (Axis ax : Axis.values()) {
            this.axstatus.put(ax, axes.get());
        }
    }

    public ShutterStatus(ByteBuffer data) {
        super(data);
        this.motionProfile = data.getInt();
        this.isCalibrated = Tools.getBoolean(data);
        this.smState = data.getInt();
        this.axstatus = new EnumMap<Axis, AxisStatus>(Axis.class);
        for (Axis ax : Axis.values()) {
            this.axstatus.put(ax, new AxisStatus(data));
        }
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(this.motionProfile);
        Tools.putBoolean(data, this.isCalibrated);
        data.putInt(this.smState);
        for (Axis ax : Axis.values()) {
            this.getAxisStatus(ax).encode(data);
        }
    }

    public int getMotionProfile() {
        return this.motionProfile;
    }

    public boolean isCalibrated() {
        return this.isCalibrated;
    }

    public int getSmState() {
        return this.smState;
    }

    public AxisStatus getAxisStatus(Axis ax) {
        return this.axstatus.get((Object)ax);
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("ShutterStatus{" + super.toString() + " motionProfile=" + this.motionProfile + ", isCalibrated=" + this.isCalibrated + ", smState=" + this.smState);
        for (Axis ax : Axis.values()) {
            buff.append(", axstatus[");
            buff.append((Object)ax);
            buff.append("]=");
            buff.append(this.getAxisStatus(ax));
        }
        buff.append("}");
        return buff.toString();
    }
}

