/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.shutter.plc.Axis;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;

public class ChangeBrakeState
extends MsgToPLC {
    private final Axis axis;
    private final State state;

    public ChangeBrakeState(Axis axis, State state) {
        this.axis = axis;
        this.state = state;
    }

    public ChangeBrakeState(ByteBuffer data) {
        super(data);
        this.axis = Axis.fromAxisNum(data.getInt());
        this.state = State.fromPowerOn(data.get());
    }

    @Override
    public void encode(ByteBuffer data) {
        super.encode(data);
        data.putInt(this.axis.getPLCAxisNum());
        data.put(this.state.getPowerOn());
    }

    @Override
    public String toString() {
        return "ChangeBrakeState{" + super.toString() + " axis=" + (Object)((Object)this.axis) + ", state=" + (Object)((Object)this.state) + '}';
    }

    public static enum State {
        SET(0),
        RELEASED(1);

        private final int powerOn;

        private State(int powerOn) {
            this.powerOn = powerOn;
        }

        byte getPowerOn() {
            return (byte)this.powerOn;
        }

        static State fromPowerOn(byte powerOn) {
            return powerOn == 0 ? SET : RELEASED;
        }
    }
}

