/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.plc;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.lsst.ccs.subsystem.shutter.plc.Tools;

public class AxisStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double actPos;
    private final double actVel;
    private final double setAcc;
    private final boolean enabled;
    private final boolean brakeSet;
    private final boolean lowLimit;
    private final boolean highLimit;
    private final boolean isHomed;
    private final int errorID;
    private final double motorTemp;

    public AxisStatus(double actPos, double actVel, double setAcc, boolean enabled, boolean brakeSet, boolean lowLimit, boolean highLimit, boolean isHomed, int errorID, double motorTemp) {
        this.actPos = actPos;
        this.actVel = actVel;
        this.setAcc = setAcc;
        this.enabled = enabled;
        this.brakeSet = brakeSet;
        this.lowLimit = lowLimit;
        this.highLimit = highLimit;
        this.isHomed = isHomed;
        this.errorID = errorID;
        this.motorTemp = motorTemp;
    }

    public AxisStatus(ByteBuffer data) {
        this.actPos = data.getDouble();
        this.actVel = data.getDouble();
        this.setAcc = data.getDouble();
        this.enabled = Tools.getBoolean(data);
        this.brakeSet = Tools.getBoolean(data);
        this.lowLimit = Tools.getBoolean(data);
        this.highLimit = Tools.getBoolean(data);
        this.isHomed = Tools.getBoolean(data);
        this.errorID = data.getInt();
        this.motorTemp = data.getDouble();
    }

    public void encode(ByteBuffer data) {
        data.putDouble(this.actPos);
        data.putDouble(this.actVel);
        data.putDouble(this.setAcc);
        Tools.putBoolean(data, this.enabled);
        Tools.putBoolean(data, this.brakeSet);
        Tools.putBoolean(data, this.lowLimit);
        Tools.putBoolean(data, this.highLimit);
        Tools.putBoolean(data, this.isHomed);
        data.putInt(this.errorID);
        data.putDouble(this.motorTemp);
    }

    public String toString() {
        return "AxisStatus{actPos=" + this.actPos + ", actVel=" + this.actVel + ", setAcc=" + this.setAcc + ", enabled=" + this.enabled + ", brakeSet=" + this.brakeSet + ", lowLimit=" + this.lowLimit + ", highLimit=" + this.highLimit + ", isHomed=" + this.isHomed + ", errorID=" + this.errorID + ", motorTemp=" + this.motorTemp + '}';
    }

    public double getActPos() {
        return this.actPos;
    }

    public double getActVel() {
        return this.actVel;
    }

    public double getSetAcc() {
        return this.setAcc;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isBrakeSet() {
        return this.brakeSet;
    }

    public boolean atLowLimit() {
        return this.lowLimit;
    }

    public boolean atHighLimit() {
        return this.highLimit;
    }

    public boolean isHomed() {
        return this.isHomed;
    }

    public int getErrorID() {
        return this.errorID;
    }

    public double getMotorTemp() {
        return this.motorTemp;
    }
}

