/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.lsst.ccs.subsystem.shutter.plc.MsgToPLC;
import org.lsst.ccs.subsystem.shutter.plc.PLCMsg;
import org.lsst.ccs.subsystem.shutter.statemachine.EventReply;

class PLCVariableDictionary {
    private final Map<Class<? extends MsgToPLC>, InVariable> inVars = new HashMap<Class<? extends MsgToPLC>, InVariable>();
    private final Map<String, InVariable> ackVars = new HashMap<String, InVariable>();
    private final Map<String, OutVariable> outVars = new HashMap<String, OutVariable>();

    private static String trimPLCSuffix(String varName) {
        return varName.replaceFirst("PLC\\z", "");
    }

    private static String inVarName(Class<?> klass) {
        return PLCVariableDictionary.trimPLCSuffix("in" + klass.getSimpleName());
    }

    private static String ackVarName(Class<?> klass) {
        return PLCVariableDictionary.inVarName(klass).replaceFirst("in", "ack");
    }

    private static String outVarName(Class<?> klass) {
        return PLCVariableDictionary.inVarName(klass).replaceFirst("in", "out");
    }

    public synchronized void addMsgToPLC(Class<? extends MsgToPLC> klass, Function<ByteBuffer, MsgToPLC> ackDecoder) {
        InVariable var = new InVariable(Objects.requireNonNull(klass, "klass must not be null."), Objects.requireNonNull(ackDecoder, "ackDecoder must not be null."));
        if (null != this.inVars.putIfAbsent(klass, var)) {
            throw new IllegalArgumentException("Variable is already registered.");
        }
        this.ackVars.put(var.ackName, var);
    }

    public synchronized void addMsgFromPLC(Class<? extends PLCMsg> klass, Function<ByteBuffer, PLCMsg> decoder, Function<PLCMsg, EventReply> submitter) {
        assert (!MsgToPLC.class.isAssignableFrom(klass));
        OutVariable var = new OutVariable(Objects.requireNonNull(klass, "klass must not be null."), Objects.requireNonNull(decoder, "decoder must not be null."), Objects.requireNonNull(submitter, "receptionAction must not be null."));
        if (null != this.outVars.putIfAbsent(var.varName, var)) {
            throw new IllegalArgumentException("Class has already been registered.");
        }
    }

    public synchronized List<InVariable> getAllInVariables() {
        return Collections.unmodifiableList(new ArrayList<InVariable>(this.inVars.values()));
    }

    public synchronized List<OutVariable> getAllOutVariables() {
        return Collections.unmodifiableList(new ArrayList<OutVariable>(this.outVars.values()));
    }

    public synchronized InVariable getInVariable(Class<? extends MsgToPLC> klass) {
        return this.inVars.get(Objects.requireNonNull(klass, "klass must not be null."));
    }

    public synchronized InVariable getInVariable(String ackName) {
        return this.ackVars.get(Objects.requireNonNull(ackName, "ackName must not be null."));
    }

    public synchronized OutVariable getOutVariable(String varName) {
        return this.outVars.get(Objects.requireNonNull(varName, "varName must noy be null."));
    }

    public synchronized OutVariable getOutVariable(Class<? extends PLCMsg> klass) {
        return this.getOutVariable(PLCVariableDictionary.outVarName(Objects.requireNonNull(klass, "klass must not be null.")));
    }

    static class OutVariable {
        final Class<? extends PLCMsg> klass;
        final Function<ByteBuffer, PLCMsg> decoder;
        final String varName;
        final Function<PLCMsg, EventReply> submitter;

        OutVariable(Class<? extends PLCMsg> klass, Function<ByteBuffer, PLCMsg> decoder, Function<PLCMsg, EventReply> submitter) {
            this.klass = klass;
            this.decoder = decoder;
            this.varName = PLCVariableDictionary.outVarName(klass);
            this.submitter = submitter;
        }
    }

    static class InVariable {
        final Class<? extends MsgToPLC> klass;
        final Function<ByteBuffer, MsgToPLC> ackDecoder;
        final String varName;
        final String ackName;

        InVariable(Class<? extends MsgToPLC> klass, Function<ByteBuffer, MsgToPLC> ackDecoder) {
            this.klass = klass;
            this.varName = PLCVariableDictionary.inVarName(klass);
            this.ackName = PLCVariableDictionary.ackVarName(klass);
            this.ackDecoder = ackDecoder;
        }
    }
}

