/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.sim;

import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.lsst.ccs.subsystems.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystems.shutter.sim.MotorPosition;

public final class MotorSimulator {
    private final MotorPosition[] positions;

    public MotorSimulator(double startPosition, double dt, int numSamples, long startTime, MotionProfile profile) {
        this.positions = (MotorPosition[])DoubleStream.iterate(0.0, x -> x + dt).limit(numSamples).map(t -> Math.rint(1000000.0 * t) / 1000000.0).mapToObj(t -> new MotorPosition(startPosition + profile.distance(t), profile.velocity(t), profile.acceleration(t), startTime + Math.round(1000000.0 * t))).toArray(MotorPosition[]::new);
    }

    public Stream<MotorPosition> getPositions() {
        return Stream.of(this.positions);
    }
}

