package org.lsst.ccs.subsystems.shutter.parker;

import org.lsst.ccs.drivers.parker.ProgramName;
import static org.lsst.ccs.drivers.parker.ProgramName.PROG0;
import static org.lsst.ccs.drivers.parker.ProgramName.PROG1;
import static org.lsst.ccs.drivers.parker.ProgramName.PROG2;
import static org.lsst.ccs.drivers.parker.ProgramName.PROG3;
import org.lsst.ccs.drivers.parker.UserParameter;
import static org.lsst.ccs.drivers.parker.UserParameter.USER0;
import static org.lsst.ccs.drivers.parker.UserParameter.USER1;
import static org.lsst.ccs.drivers.parker.UserParameter.USER2;
import static org.lsst.ccs.drivers.parker.UserParameter.USER3;
import static org.lsst.ccs.drivers.parker.UserParameter.USER4;
import static org.lsst.ccs.drivers.parker.UserParameter.USER5;
import static org.lsst.ccs.drivers.parker.UserParameter.USER6;
import static org.lsst.ccs.drivers.parker.UserParameter.USER7;
import static org.lsst.ccs.drivers.parker.UserParameter.USER8;

/**
 * Holds various constant definitions for the package.
 * @author tether
 */
public class ParkerConstants {
    
    /** Use an S-curve motion profile. */
    public final static int    MOV_TYP_SCURVE = 0;
    
    /** Use a trapezoidal motion profile. */
    public final static int    MOV_TYP_TRAP   = 1;
    
    /** Start looking for home by going in the negative direction (decreasing absolute position). */
    public final static int    HOM_OPT_NDIRN  = 0x01;
    
    /** Make the final approach to home from the positive side (higher absolute position). */
    public final static int    HOM_OPT_PFINAL = 0x02;
    
    /** The limit on the motor torque expressed as amps supplied by the motor driver. */
    public final static double TORQUE_LIM   = 10.0;
    
    /**
     * User parameter used for the axis to move.
     */
    public final static UserParameter P_AXIS_NUMBER = USER0;
    /**
     * User parameter used for the "leave drive on after motion" flag.
     */
    public final static UserParameter P_DRIVE_ON = USER1;
    /**
     * User parameter used for the signed distance to travel in mm.
     */
    public final static UserParameter P_MOVE_DISTANCE = USER2;
    /**
     * User parameter used to report the progress of the motion program. At the appropriate
     * points the motion program sets this parameter to one of the progress code
     * values PCD_xxxx. before running the program, the subsystem sets this
     * parameter to PCD_NEVER_STARTED.
     */
    public final static UserParameter P_PROGRESS = USER3;
    /**
     * User parameter used for the time between parameter sampling during motion.
     */
    public final static UserParameter P_SAMPLE_INTERVAL = USER4;
    /**
     * User parameter used for the number of samples to take of each parameter.
     */
    public final static UserParameter P_NUM_SAMPLES = USER5;
    /**
     * User parameter used for the number of integer (long) parameters to be sampled.
     */
    public final static UserParameter P_NUM_INT_PARAMS = USER6;
    /**
     * User parameter used for the number of float (single) parameters to sample.
     */
    public final static UserParameter P_NUM_FLOAT_PARAMS = USER7;
    /**
     * User parameter used for the index number of the first parameter to sample, where the indexes for the
     * integer parameters come before those of the float parameters.
     */
    public final static UserParameter P_FIRST_PARAM_NUMBER = USER8;
    
    /**
     * The controller program used for general motion.
     */
    public final static ProgramName MOVE_PROG = PROG0;
    /**
     * The controller program used for Hall calibration.
     */
    public final static ProgramName CAL_PROG = PROG1;
    /**
     * The controller program used to perform a general checkup of the controller.
     */
    public final static ProgramName TEST_PROG = PROG2;
    /**
     * A controller program loaded on the fly for various purposes.
     */
    public final static ProgramName TEMP_PROG = PROG3;
    
    /**
     * Progress code: the motion program didn't run.
     */
    public final static int PCD_NEVER_STARTED = 0;
    
    /**
     * Progress code: the motion program started running.
     */
    public final static int PCD_STARTED = 1;
    
    /**
     * Progress code: the motion program has finished setting up sampling for
     * the move.
     */
    public final static int PCD_SAMPLING_SET_UP = 2;
    
    /**
     * Progress code: the motion program has started the actual motion.
     */
    public final static int PCD_MOTION_STARTED = 3;
    
    /**
     * Progress code: the motion program has detected the end of motion.
     */
    public final static int PCD_MOTION_COMPLETE = 4;
    
    /**
     * Progress code: the motion program has detected the completion
     * of sampling for the move.
     */
    public final static int PCD_SAMPLING_COMPLETE = 5;
    
    /**
     * Progress code: the motion program has exited.
     */
    public final static int PCD_DONE = 6;

}
