package org.lsst.ccs.subsystems.shutter;

import java.util.Arrays;
import org.lsst.ccs.subsystems.shutter.common.ShutterConfiguration;

import org.lsst.ccs.drivers.parker.ControllerType;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;

import org.lsst.ccs.framework.ConfigurableComponent;

import java.util.HashMap;
import java.util.Map;

/**
 * Holds the general shutter configuration data as obtained from the CCS config service.
 * There will be one instance of this class created by the subsystem build script
 * and named "shutter".
 * @author tether
 */
public final class ShutterCCSConfig extends ConfigurableComponent {
    
    ////////// Lifecycle methods //////////
    
    public ShutterCCSConfig() {
        super();
    }
    
    ////////// Configuration data //////////
    @ConfigurationParameter(description="General configuration data for the subsystem.")
    private volatile Map<String, String> config = null;
    
    /**
     * Gets a shallow, modifiable copy of the configuration info. It may need to be modified before
     * conversion.
     * @return the configuration info, or null if it's missing.
     */
    public Map<String, String> getConfiguration() {
        return config==null ? null : new HashMap<>(config);
    }
}
