package org.lsst.ccs.subsystems.shutter;

import org.lsst.ccs.commons.annotations.ConfigurationParameter;

import org.lsst.ccs.framework.ConfigurableComponent;

import java.util.ArrayList;
import java.util.List;


/**
 * Holds configuration data all Hall sensors as obtained from the CCS config service.
 * There will be one instance of this class created by the subsystem build script
 * and named "hall".
 * @author tether
 */
public final class HallCCSConfig extends ConfigurableComponent {
    
    ////////// Lifecycle methods //////////
    
    public HallCCSConfig() {
        super();
    }
    
    ////////// Configuration data //////////
    @ConfigurationParameter(description="Hall sensor configuration data.")
    // TODO: This should properly be a list of maps but due to a bug in class
    // InputConversionEngine the maps aren't parsed as maps but
    // are left as simple strings.
    private volatile List<String> config = null;
    
    /**
     * Gets a shallow, modifiable copy of the configuration info. It may need to be modified
     * before conversion.
     * @return the copied info, or null if it's missing.
     */
    public List<String> getConfiguration() {
        return config==null ? null : new ArrayList<>(config);
    }
}
