package org.lsst.ccs.subsystems.shutter;


import org.lsst.ccs.commons.annotations.ConfigurationParameter;

import org.lsst.ccs.framework.ConfigurableComponent;

import java.util.HashMap;
import java.util.Map;

/**
 * Holds configuration data for one blade set as obtained from the CCS config service.
 * There will be two instances of this class made by the subsystem build script and named
 * "minusx" and "plusx".
 * @author tether
 */
public final class BladeSetCCSConfig extends ConfigurableComponent {
    
    ////////// Lifecycle methods //////////
    
    public BladeSetCCSConfig() {
        super();
    }
    
    ////////// Configuration data //////////
    @ConfigurationParameter(description="Blade set configuration data.")
    private volatile Map<String, String> config = null;
    
    /**
     * Gets a shallow, modifiable copy of the configuration info. It may need to be modified
     * before conversion.
     * @return the copied info, or null if the info is missing.
     */
    public Map<String, String> getConfiguration() {
        return config==null ? null : new HashMap<>(config);
    }
}
