/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter.parker;

import java.io.IOException;
import java.io.PrintStream;
import java.util.GregorianCalendar;
import java.util.List;
import org.lsst.ccs.drivers.iocard.AccesDio;
import org.lsst.ccs.drivers.iocard.Helios;
import org.lsst.ccs.drivers.parker.AcrComm;
import org.lsst.ccs.drivers.parker.TestAcrComm;
import org.lsst.ccs.subsystems.shutter.common.BladePosition;
import org.lsst.ccs.subsystems.shutter.common.BladeSetCalibration;
import org.lsst.ccs.subsystems.shutter.common.BladeSetConfiguration;
import org.lsst.ccs.subsystems.shutter.common.HallTransition;
import org.lsst.ccs.subsystems.shutter.common.MovementHistory;
import org.lsst.ccs.subsystems.shutter.parker.BladeSetDrvr;
import org.lsst.ccs.subsystems.shutter.parker.MovementStatus;
import org.lsst.ccs.utilities.sa.CmndProcess;
import org.lsst.ccs.utilities.sa.ConsOut;
import org.lsst.ccs.utilities.sa.Output;

public class TestBladeSet
implements CmndProcess.Dispatch {
    private static final int DRV_OFF = 0;
    private static final int DRV_ON = 1;
    private static final int TEST_PROG = 2;
    private static final int CMD_CALIB = 0;
    private static final int CMD_STEP = 1;
    private static final int CMD_HOME = 2;
    private static final int CMD_MOVE = 3;
    private static final int CMD_MOVEP = 4;
    private static final int CMD_MOVEH = 5;
    private static final int CMD_MOVED = 6;
    private static final int CMD_CALREAD = 7;
    private static final int CMD_CALSHOW = 8;
    private static final int CMD_PULSE = 9;
    private static final int CMD_CALTEST = 10;
    private static final int CMD_MOVEX = 11;
    private static final int CMD_THRSHOW = 12;
    private static final int CMD_TIMESYNC = 13;
    private static final int CMD_HALLTEST = 14;
    private static final int CMD_DRIVE = 15;
    private static final int CMD_MOVETEST = 16;
    private static final int CMD_ENCTEST = 17;
    private static final int CMD_POSITION = 18;
    private static final int CMD_CONFSHOW = 19;
    private static final int CMD_TEMPSHOW = 20;
    private static final int NUM_CMDS = 21;
    private static final String[] helpConfshow = new String[]{"Show the blade configuration data", "confshow"};
    private static final String[] helpDrive = new String[]{"Set drive state", "drive  <state>", "state  The state to set, either 'on' or 'off'"};
    private static final String[] helpCalib = new String[]{"Calibrate Hall switch positions", "calibrate <dist> <step> [<time>] [<file>]", "dist    The total distance to travel (mm)", "step    The step size (mm)", "time    The time for each step (sec) (default 0.1)", "file    The base name of the file to receive the calibration data"};
    private static final String[] helpCaltest = new String[]{"Calibrate Hall switch positions (new calibration test)", "caltest <type> <dist> [<time>] [<file>]", "type    The test type: 0 = new cal; 1 = cap test 1; 2 = cap test 2", "dist    The distance to move (mm)", "time    The time for the move (sec) (default 10)", "file    The base name of the file to receive the calibration data"};
    private static final String[] helpCalread = new String[]{"Read file of Hall switch positions", "calread [<file>]", "file    The name of the file containing the calibration data"};
    private static final String[] helpCalshow = new String[]{"Show the Hall switch position data", "calshow"};
    private static final String[] helpPosition = new String[]{"Position the shutter blade set at a fraction of its full extent", "position [<posn>] [<time>]", "posn    The position to move to (0 - 1); if absent, display it", "time    The time for the move (secs) (default 1.0)"};
    private static final String[] helpMove = new String[]{"Move the shutter blade set", "move [<dist>] [<time>] [<type>] [<mvfrac>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)"};
    private static final String[] helpMoved = new String[]{"Move the shutter blade set, recording various data values", "moved [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data file"};
    private static final String[] helpMoveh = new String[]{"Move the shutter blade set, recording Hall switch times", "moveh [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data files"};
    private static final String[] helpMovep = new String[]{"Move the shutter blade set, recording sampled positions", "movep [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data file"};
    private static final String[] helpMovex = new String[]{"Move the shutter blade set, recording test values", "movex [<dist>] [<time>] [<nsamp>] [<type>] [<mvfrac>] [<name>]", "dist    The distance to move (mm); if absent, display position", "time    The time for the move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "type    The type of move to make: 'trap' or 'scurve' (default)", "mvfrac  The fraction of the time at maximum velocity (default 0)", "name    The root part of the name of the output data file"};
    private static final String[] helpMovetest = new String[]{"Move the shutter blade set repeatedly", "movetest <count> <dist> [<time>]", "count   The number of back-and-forth cycles to perform", "dist    The distance to move (mm)", "time    The time for each move (secs) (default 1.0)"};
    private static final String[] helpHalltest = new String[]{"Move the shutter blade set repeatedly, recording Hall switch times", "halltest <count> <dist> [<time>] [<name>]", "count   The number of back-and-forth cycles to perform", "dist    The distance to move (mm)", "time    The time for each move (secs) (default 1.0)", "name    The root part of the name of the output data file"};
    private static final String[] helpEnctest = new String[]{"Move the shutter blade set repeatedly, recording encoder profiles", "enctest <count> <dist> [<time>] [<nsamp>] [<name>]", "count   The number of back-and-forth cycles to perform", "dist    The distance to move (mm)", "time    The time for each move (secs) (default 1.0)", "nsamp   The number of times to sample the position (default 100)", "name    The root part of the name of the output data file"};
    private static final String[] helpStep = new String[]{"Step the motor, recording actual steps", "step <count> <step> [<time>]", "count  The number of steps to take", "step   The step size (encoder counts)", "time   The time for each step (sec) (default 0.1)"};
    private static final String[] helpHome = new String[]{"Find the home position", "home [<optns>] [<vel>]", "optns  Bit mask of options: 1 = neg. dirn.; 2 = pos. final (dflt 0)", "vel    Velocity (mm/sec) (default 10)"};
    private static final String[] helpPulse = new String[]{"Start or stop regular pulse on DIO line", "pulse <freq> [<line>] [<count>] [<fract>]", "freq   The pulse frequency; 0 = off", "line   The digital output line to use (default: ACR line)", "count  If >= 0, the maximum number of pulses to generate (default -1)", "fract  The fraction of time the pulse is on (default 0.5)"};
    private static final String[] helpTimesync = new String[]{"Time the synchronization between computer and motor controller", "timesync  [<capt>] [<count>]", "capt   If non-zero, use capture for synch'ing (default not)", "count  The number of pulses to generate (default 10)"};
    private static final String[] helpTempshow = new String[]{"Show the drive and ambient temperatures", "tempshow"};
    private static final String[] helpThrshow = new String[]{"Show thread information", "thrshow"};
    private static final CmndProcess.Lookup moveTypes = new CmndProcess.Lookup(2);
    private static final CmndProcess.Lookup driveTypes;
    private static final CmndProcess.Command cmnd;
    private final Output out;
    private final CmndProcess proc;
    private final int dioOPort;
    private final int dioOLine;
    private final int dioIPort;
    private final int dioILine;
    private final int bladeIndex;
    private final BladeSetDrvr blade;
    private final BladeSetConfiguration config;
    private final TestAcrComm tacr;
    private final AccesDio acd;
    private final Helios hel;
    private final AcrComm acr;
    private String moveName = "Move_";
    private String calibName = "Calib_";
    private String caltName = "Calt_";
    private String hallName = "Hall_";
    private String encName = "Enc_";
    private MovementHistory mhData;

    public TestBladeSet(int index, CmndProcess proc, Output out) {
        this.proc = proc;
        this.out = out;
        this.bladeIndex = index;
        this.blade = new BladeSetDrvr(this.bladeIndex);
        this.blade.init();
        this.config = this.blade.getConfig();
        this.dioOPort = this.config.getDioOPort();
        this.dioOLine = this.config.getDioOLine();
        this.dioIPort = this.config.getDioIPort();
        this.dioILine = this.config.getDioILine();
        this.acd = this.blade.getAcces();
        this.hel = this.blade.getHelios();
        this.acr = this.blade.getComm();
        this.tacr = new TestAcrComm(this.acr, proc, out);
    }

    public void run() {
        this.proc.add((CmndProcess.Dispatch)this, cmnd);
        this.tacr.run();
    }

    public static void main(String[] args) {
        int index = 0;
        if (args.length != 0) {
            try {
                index = Integer.valueOf(args[0]);
            }
            catch (NumberFormatException e) {
                System.out.println("Blade set index is not an integer");
                System.exit(0);
            }
            if (index < 0 || index > 1) {
                System.out.println("Blade set index must be 0 or 1");
                System.exit(0);
            }
        }
        ConsOut out = new ConsOut();
        CmndProcess proc = new CmndProcess();
        TestBladeSet bset = new TestBladeSet(index, proc, (Output)out);
        bset.run();
        System.exit(0);
    }

    public void process(String command) {
        this.tacr.process(command);
    }

    public boolean dispatch(int code, int found, Object[] args) {
        switch (code) {
            case 19: {
                this.procConfshow(found, args);
                break;
            }
            case 15: {
                this.procDrive(found, args);
                break;
            }
            case 0: {
                this.procCalib(found, args);
                break;
            }
            case 10: {
                this.procCaltest(found, args);
                break;
            }
            case 7: {
                this.procCalread(found, args);
                break;
            }
            case 8: {
                this.procCalshow(found, args);
                break;
            }
            case 18: {
                this.procPosition(found, args);
                break;
            }
            case 3: {
                this.procMove(found, args);
                break;
            }
            case 6: {
                this.procMoved(found, args);
                break;
            }
            case 5: {
                this.procMoveh(found, args);
                break;
            }
            case 4: {
                this.procMovep(found, args);
                break;
            }
            case 11: {
                this.procMovex(found, args);
                break;
            }
            case 16: {
                this.procMovetest(found, args);
                break;
            }
            case 14: {
                this.procHalltest(found, args);
                break;
            }
            case 17: {
                this.procEnctest(found, args);
                break;
            }
            case 1: {
                this.procStep(found, args);
                break;
            }
            case 2: {
                this.procHome(found, args);
                break;
            }
            case 9: {
                this.procPulse(found, args);
                break;
            }
            case 13: {
                this.procTimesync(found, args);
                break;
            }
            case 20: {
                this.procTempshow(found, args);
                break;
            }
            case 12: {
                this.procThrshow(found, args);
                break;
            }
            default: {
                this.out.println((Object)"Command not fully implemented");
            }
        }
        return true;
    }

    private void procConfshow(int found, Object[] args) {
        this.out.format("Blade %s Configuration:\n", new Object[]{this.config.getIndex()});
        this.out.format("  Controller node:             %s\n", new Object[]{this.config.getNode()});
        this.out.format("  Encoder pulses/mm:           %s\n", new Object[]{this.config.getPpMm()});
        this.out.format("  Blade home position (mm):    %s\n", new Object[]{this.config.getHome()});
        this.out.format("  Blade open position (mm):    %s\n", new Object[]{this.config.getOpen()});
        this.out.format("  Blade closed position (mm):  %s\n", new Object[]{this.config.getClosed()});
        this.out.format("  Position sample count:       %s\n", new Object[]{this.config.getNumSamp()});
        this.out.format("  Blade movement time (sec):   %s\n", new Object[]{this.config.getMoveTime()});
        this.out.format("  DIO board base address:      0x%04x\n", new Object[]{this.config.getDioAddr()});
        this.out.format("  DIO board IRQ level:         %s\n", new Object[]{this.config.getDioLevel()});
        this.out.format("  DIO board configuration:     0x%02x\n", new Object[]{this.config.getDioConf()});
        this.out.format("  Hall sensor DIO port:        %s\n", new Object[]{this.config.getDioHPort()});
        this.out.format("  Motor output DIO port:       %s\n", new Object[]{this.config.getDioOPort()});
        this.out.format("  Motor output DIO line:       %s\n", new Object[]{this.config.getDioOLine()});
        this.out.format("  Motor input DIO port:        %s\n", new Object[]{this.config.getDioIPort()});
        this.out.format("  Motor input DIO line:        %s\n", new Object[]{this.config.getDioILine()});
        this.out.format("  AD board base address:       0x%04x\n", new Object[]{this.config.getAdAddr()});
        this.out.format("  AD board IRQ level:          %s\n", new Object[]{this.config.getAdLevel()});
        this.out.format("  Temperature AD channel:      %s\n", new Object[]{this.config.getAdTempChn()});
    }

    private void procDrive(int found, Object[] args) {
        if ((Integer)args[0] == 1) {
            this.blade.setDriveOn();
        } else {
            this.blade.setDriveOff();
        }
    }

    private void procCalib(int found, Object[] args) {
        double time;
        double dist = (Double)args[0];
        double step = (Double)args[1];
        double d = time = (found & 4) != 0 ? (Double)args[2] : (double)0.1f;
        if ((found & 8) != 0) {
            this.calibName = (String)args[3] + "_";
        }
        String file = this.genFileName(this.calibName, ".dat");
        BladeSetCalibration calData = this.blade.calibrate(dist, step, time);
        this.showStop(calData.getStatus());
        BladeSetConfiguration.writeCalibration((BladeSetCalibration)calData, (String)file);
        this.out.println((Object)("File " + file + " created"));
    }

    private void procCaltest(int found, Object[] args) {
        if ((found & 8) != 0) {
            this.caltName = (String)args[3] + "_";
        }
        int type = (Integer)args[0];
        double dist = (Double)args[1];
        double time = (found & 4) != 0 ? (Double)args[2] : 10.0;
        String file = this.genFileName(this.caltName + type + "_", ".dat");
        if (type == 0) {
            this.calTest(dist, time, file);
        } else if (type == 1 || type == 3) {
            this.calTest1(type == 1, dist, time, file);
        } else if (type == 2) {
            this.calTest2(dist, time, file);
        } else if (type == 4) {
            this.calTest4(dist, time, file);
        } else {
            this.out.println((Object)"Invalid caltest type");
        }
    }

    private void procCalread(int found, Object[] args) {
        if ((found & 1) != 0) {
            BladeSetConfiguration.readCalibration((String)((String)args[0]));
        } else {
            BladeSetConfiguration.readCalibration((int)this.config.getIndex());
        }
    }

    private void procCalshow(int found, Object[] args) {
        List cList = this.config.getCalibration().getData();
        this.out.println((Object)"Dirn   Swtch   Index   Action   Position");
        this.out.println((Object)"----   -----   -----   ------   --------");
        for (int j = 0; j < cList.size(); ++j) {
            BladeSetCalibration.Item data = (BladeSetCalibration.Item)cList.get(j);
            this.out.format("%4s   %5s   %5s   %6s   %8.2f\n", new Object[]{data.isReverse() ? "Back" : "Forw", data.getSensor(), data.getIndex(), data.isOpen() ? "Open " : "Close", data.getPosition()});
        }
    }

    private void procPosition(int found, Object[] args) {
        double time;
        if ((found & 1) == 0) {
            this.showRelPosition();
            return;
        }
        double relPosn = (Double)args[0];
        double d = time = (found & 2) != 0 ? ((Double)args[1]).doubleValue() : this.config.getMoveTime();
        if ((found & 4) != 0) {
            this.moveName = (String)args[2] + "_";
        }
        long tStamp = System.currentTimeMillis();
        String fileH = this.genFileName(this.moveName, "_H.dat", tStamp);
        String fileP = this.genFileName(this.moveName, "_P.dat", tStamp);
        PrintStream oflH = null;
        PrintStream oflP = null;
        try {
            oflH = new PrintStream(fileH);
            oflP = new PrintStream(fileP);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            if (oflH != null) {
                oflH.close();
            }
            if (oflP != null) {
                oflP.close();
            }
            return;
        }
        this.showMoveStart();
        this.blade.moveToPosition(relPosn, time);
        this.showMoveEnd();
        if (this.mhData == null) {
            oflH.close();
            oflP.close();
            return;
        }
        this.showStop(this.mhData.getStatus());
        this.writePosnData(this.mhData, oflP);
        this.writeHallData(this.mhData, oflH);
        oflH.close();
        oflP.close();
        this.out.println((Object)("Files " + fileH + " and " + fileP + " created"));
    }

    private void procMove(int found, Object[] args) {
        if ((found & 1) == 0) {
            this.showPosition();
            return;
        }
        int type = (found & 4) != 0 ? (Integer)args[2] : 0;
        double dist = (Double)args[0];
        double time = (found & 2) != 0 ? ((Double)args[1]).doubleValue() : this.config.getMoveTime();
        double mvFrac = (found & 8) != 0 ? (Double)args[3] : 0.0;
        this.showMoveStart();
        int status = this.blade.move(type, dist, time, mvFrac);
        this.showMoveEnd();
        this.showStop(status);
    }

    private void procMoved(int found, Object[] args) {
        PrintStream ofl;
        double mvFrac;
        if ((found & 1) == 0) {
            this.showPosition();
            return;
        }
        double dist = (Double)args[0];
        double time = (found & 2) != 0 ? ((Double)args[1]).doubleValue() : this.config.getMoveTime();
        int nSamp = (found & 4) != 0 ? ((Integer)args[2]).intValue() : this.config.getNumSamp();
        int type = (found & 8) != 0 ? (Integer)args[3] : 0;
        double d = mvFrac = (found & 0x10) != 0 ? (Double)args[4] : 0.0;
        if ((found & 0x20) != 0) {
            this.moveName = (String)args[5] + "_";
        }
        String file = this.genFileName(this.moveName, "_D.dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int[] iParms = new int[]{6916, 6144, 4120};
        int[] fParms = new int[]{28738, 28739, 28740, 28745};
        this.showMoveStart();
        BladeSetDrvr.SampData data = this.blade.moveD(type, dist, time, mvFrac, nSamp, iParms, fParms);
        this.showMoveEnd();
        this.showStop(data.status);
        if (data == null) {
            ofl.close();
            return;
        }
        for (int j = 0; j < data.sList.size(); ++j) {
            BladeSetDrvr.Sample samp = data.sList.get(j);
            ofl.format("%12s %5s %8.2f %12s %12s %12s %12s %08x\n", data.startTime + (long)(samp.time / 1000), samp.time / 1000, this.config.position(samp.iVals[1]), Float.valueOf(samp.fVals[0]), Float.valueOf(samp.fVals[1]), Float.valueOf(samp.fVals[2]), Float.valueOf(samp.fVals[3]), samp.iVals[2]);
            if ((samp.iVals[2] & 0x1000000) == 0) break;
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void procMoveh(int found, Object[] args) {
        double mvFrac;
        if ((found & 1) == 0) {
            this.showPosition();
            return;
        }
        double dist = (Double)args[0];
        double time = (found & 2) != 0 ? ((Double)args[1]).doubleValue() : this.config.getMoveTime();
        int nSamp = (found & 4) != 0 ? ((Integer)args[2]).intValue() : this.config.getNumSamp();
        int type = (found & 8) != 0 ? (Integer)args[3] : 0;
        double d = mvFrac = (found & 0x10) != 0 ? (Double)args[4] : 0.0;
        if ((found & 0x20) != 0) {
            this.moveName = (String)args[5] + "_";
        }
        long tStamp = System.currentTimeMillis();
        String fileH = this.genFileName(this.moveName, "_H.dat", tStamp);
        String fileP = this.genFileName(this.moveName, "_P.dat", tStamp);
        PrintStream oflH = null;
        PrintStream oflP = null;
        try {
            oflH = new PrintStream(fileH);
            oflP = new PrintStream(fileP);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            if (oflH != null) {
                oflH.close();
            }
            if (oflP != null) {
                oflP.close();
            }
            return;
        }
        this.showMoveStart();
        MovementHistory data = this.blade.moveH(type, dist, time, mvFrac, nSamp);
        this.showMoveEnd();
        this.showStop(data.getStatus());
        this.writePosnData(data, oflP);
        this.writeHallData(data, oflH);
        oflH.close();
        oflP.close();
        this.out.println((Object)("Files " + fileH + " and " + fileP + " created"));
    }

    private void procMovep(int found, Object[] args) {
        PrintStream ofl;
        double mvFrac;
        if ((found & 1) == 0) {
            this.showPosition();
            return;
        }
        double dist = (Double)args[0];
        double time = (found & 2) != 0 ? ((Double)args[1]).doubleValue() : this.config.getMoveTime();
        int nSamp = (found & 4) != 0 ? ((Integer)args[2]).intValue() : this.config.getNumSamp();
        int type = (found & 8) != 0 ? (Integer)args[3] : 0;
        double d = mvFrac = (found & 0x10) != 0 ? (Double)args[4] : 0.0;
        if ((found & 0x20) != 0) {
            this.moveName = (String)args[5] + "_";
        }
        String file = this.genFileName(this.moveName, "_P.dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        this.showMoveStart();
        MovementHistory data = this.blade.moveP(type, dist, time, mvFrac, nSamp);
        this.showMoveEnd(data.getEndPosition(), data.getEndTime() / 1000L);
        this.showStop(data.getStatus());
        if (data == null) {
            ofl.close();
            return;
        }
        this.writePosnData(data, ofl);
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void procMovex(int found, Object[] args) {
        PrintStream ofl;
        double mvFrac;
        if ((found & 1) == 0) {
            this.showPosition();
            return;
        }
        double dist = (Double)args[0];
        double time = (found & 2) != 0 ? ((Double)args[1]).doubleValue() : this.config.getMoveTime();
        int nSamp = (found & 4) != 0 ? ((Integer)args[2]).intValue() : this.config.getNumSamp();
        int type = (found & 8) != 0 ? (Integer)args[3] : 0;
        double d = mvFrac = (found & 0x10) != 0 ? (Double)args[4] : 0.0;
        if ((found & 0x20) != 0) {
            this.moveName = (String)args[5] + "_";
        }
        String file = this.genFileName(this.moveName, "_X.dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int[] iParms = new int[]{6144, 4096};
        int[] fParms = new int[]{};
        this.showMoveStart();
        BladeSetDrvr.SampData data = this.blade.moveD(type, dist, time, mvFrac, nSamp, iParms, fParms);
        this.showMoveEnd();
        this.showStop(data.status);
        if (data == null) {
            ofl.close();
            return;
        }
        for (int j = 0; j < data.sList.size(); ++j) {
            BladeSetDrvr.Sample samp = data.sList.get(j);
            ofl.format("%8.2f %08x\n", this.config.position(samp.iVals[0]), samp.iVals[1]);
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void procMovetest(int found, Object[] args) {
        int si;
        int count = (Integer)args[0];
        double dist = (Double)args[1];
        double time = (found & 4) != 0 ? ((Double)args[2]).doubleValue() : this.config.getMoveTime();
        boolean type = false;
        double mxvf = 0.0;
        if (dist < 0.0) {
            dist = -dist;
        }
        if (dist == 0.0) {
            dist = 10.0;
        }
        this.showMoveStart();
        int status = 0;
        for (si = 0; si < count && (status = this.blade.move(0, dist, time, 0.0)) == 0 && (status = this.blade.move(0, -dist, time, 0.0)) == 0; ++si) {
        }
        this.showMoveEnd();
        if (status != 0) {
            this.out.format("%s after %s cycles\n", new Object[]{this.getStop(status), si});
        } else {
            this.out.format("%s cycles completed successfully\n", new Object[]{si});
        }
    }

    private void procHalltest(int found, Object[] args) {
        PrintStream ofl;
        double time;
        int count = (Integer)args[0];
        double dist = (Double)args[1];
        double d = time = (found & 4) != 0 ? ((Double)args[2]).doubleValue() : this.config.getMoveTime();
        if ((found & 8) != 0) {
            this.hallName = (String)args[3] + "_";
        }
        List cList = this.config.getCalibration().getData();
        String file = this.genFileName(this.hallName, ".dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        if (count <= 0) {
            count = 1;
        }
        int[][] times = new int[cList.size()][count];
        if (dist < 0.0) {
            dist = -dist;
        }
        int type = 0;
        double mxvf = 0.0;
        int nSamp = this.config.getNumSamp();
        double posn = this.blade.getPosition();
        if (posn > 1.0 || posn < -1.0) {
            this.blade.move(type, -posn, 1.0, mxvf);
        }
        for (int si = 0; si < count; ++si) {
            int sensor;
            boolean open;
            BladeSetCalibration.Item cItem;
            HallTransition hItem;
            int j;
            MovementHistory data1;
            this.blade.move(type, -10.0, 1.0, mxvf);
            this.blade.home(0, 10.0);
            MovementHistory data0 = this.blade.moveH(type, -dist, time, mxvf, nSamp);
            if (data0 == null || (data1 = this.blade.moveH(type, dist, time, mxvf, nSamp)) == null) break;
            int ci = 0;
            List hList = data0.getHallTransitions();
            long sTime = data0.getStartTime();
            for (j = 0; j < hList.size(); ++j) {
                hItem = (HallTransition)hList.get(j);
                cItem = (BladeSetCalibration.Item)cList.get(ci);
                open = hItem.isOpen();
                sensor = hItem.getSensorId();
                if (!cItem.isReverse() || cItem.getSensor() != sensor || cItem.isOpen() != open) {
                    this.out.format("Inconsistent data: %s true %s %s %s %s, index = %s, cycle = %s\n", new Object[]{cItem.isReverse(), cItem.getSensor(), sensor, cItem.isOpen(), open, ci, si});
                    continue;
                }
                times[ci++][si] = (int)((hItem.getTransitionTime() - sTime + 50L) / 100L);
            }
            hList = data1.getHallTransitions();
            sTime = data1.getStartTime();
            for (j = 0; j < hList.size(); ++j) {
                hItem = (HallTransition)hList.get(j);
                cItem = (BladeSetCalibration.Item)cList.get(ci);
                open = hItem.isOpen();
                sensor = hItem.getSensorId();
                if (cItem.isReverse() || cItem.getSensor() != sensor || cItem.isOpen() != open) {
                    this.out.format("Inconsistent data: %s false %s %s %s %s, index = %s, cycle = %s\n", new Object[]{cItem.isReverse(), cItem.getSensor(), sensor, cItem.isOpen(), open, ci, si});
                    continue;
                }
                times[ci++][si] = (int)((hItem.getTransitionTime() - sTime + 50L) / 100L);
            }
        }
        for (int ci = 0; ci < cList.size(); ++ci) {
            BladeSetCalibration.Item cItem = (BladeSetCalibration.Item)cList.get(ci);
            ofl.format("%s %s %s %8.2f", cItem.getSensor(), cItem.isOpen() ? "O" : "C", cItem.isReverse() ? "-" : "+", cItem.getPosition());
            for (int si = 0; si < count; ++si) {
                ofl.format(" %5s", times[ci][si]);
            }
            ofl.println();
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void procEnctest(int found, Object[] args) {
        MovementHistory data1;
        MovementHistory data0;
        PrintStream ofl;
        int nSamp;
        int count = (Integer)args[0];
        double dist = (Double)args[1];
        double time = (found & 4) != 0 ? ((Double)args[2]).doubleValue() : this.config.getMoveTime();
        int n = nSamp = (found & 8) != 0 ? ((Integer)args[3]).intValue() : this.config.getNumSamp();
        if ((found & 0x10) != 0) {
            this.encName = (String)args[4] + "_";
        }
        String file = this.genFileName(this.encName, ".dat");
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        if (count <= 0) {
            count = 1;
        }
        long[][] times = new long[2 * nSamp][count];
        double[][] posns = new double[2 * nSamp][count];
        if (dist < 0.0) {
            dist = -dist;
        }
        int type = 0;
        double mxvf = 0.0;
        double posn = this.blade.getPosition();
        if (posn > 1.0 || posn < -1.0) {
            this.blade.move(type, -posn, 1.0, mxvf);
        }
        for (int si = 0; si < count && (data0 = this.blade.moveP(type, -dist, time, mxvf, nSamp)) != null && (data1 = this.blade.moveP(type, dist, time, mxvf, nSamp)) != null; ++si) {
            BladePosition pItem;
            int j;
            int ci = 0;
            List pList = data0.getPositions();
            long sTime = data0.getStartTime();
            int size = pList.size();
            BladePosition pDummy = new BladePosition(-1.0, -1.0);
            for (j = 0; j < nSamp; ++j) {
                pItem = j >= size ? pDummy : (BladePosition)pList.get(j);
                times[ci][si] = (pItem.getTime() - sTime + 50L) / 100L;
                posns[ci++][si] = pItem.getPosition();
            }
            pList = data1.getPositions();
            sTime = data1.getStartTime();
            size = pList.size();
            for (j = 0; j < nSamp; ++j) {
                pItem = j >= size ? pDummy : (BladePosition)pList.get(j);
                times[ci][si] = (pItem.getTime() - sTime + 50L) / 100L;
                posns[ci++][si] = pItem.getPosition();
            }
        }
        for (int ci = 0; ci < 2 * nSamp; ++ci) {
            ofl.format("%s", ci < nSamp ? "-" : "+");
            for (int si = 0; si < count; ++si) {
                ofl.format(" %5s %8.2f", times[ci][si], posns[ci][si]);
            }
            ofl.println();
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void procStep(int found, Object[] args) {
        int nStep;
        int fPosn;
        int count = (Integer)args[0];
        int step = (Integer)args[1];
        double time = (found & 4) != 0 ? (Double)args[2] : (double)0.1f;
        double vel = Math.abs((double)(2.0f * (float)step) / time);
        double acc = Math.abs((double)(8.0f * (float)step) / (time * time));
        double jrk = acc * acc / vel;
        this.acr.setFloatParm(12375, 1.0f);
        this.acr.setFloatParm(12348, (float)vel);
        this.acr.setFloatParm(12349, (float)acc);
        this.acr.setFloatParm(12350, (float)acc);
        this.acr.setFloatParm(12351, (float)jrk);
        this.acr.sendStr("axis0 slm (" + this.config.posSoftLimit() * this.config.ppu() + "," + this.config.negSoftLimit() * this.config.ppu() + ")", 0);
        this.blade.enableDrive();
        int minm = Integer.MAX_VALUE;
        int maxm = Integer.MIN_VALUE;
        int sumSq = 0;
        int pPosn = fPosn = this.acr.getIntParm(6144);
        for (nStep = 0; nStep < count; ++nStep) {
            this.acr.sendStr("axis0 jog inc " + step, 0);
            this.acr.sendStr("inh -792", 0);
            if (this.showStop() != null) break;
            int cPosn = this.acr.getIntParm(6144);
            int cStep = cPosn - pPosn;
            if (cStep > maxm) {
                maxm = cStep;
            }
            if (cStep < minm) {
                minm = cStep;
            }
            sumSq += cStep * cStep;
            pPosn = cPosn;
        }
        double avg = (double)(pPosn - fPosn) / (double)(nStep == 0 ? 1 : nStep);
        double var = (double)sumSq / (double)(nStep == 0 ? 1 : nStep) - avg * avg;
        this.out.format("Steps = %s, counts = %s, min = %s, max = %s, avg = %.2f, sigma = %.4f\n", new Object[]{nStep, pPosn - fPosn, minm == Integer.MAX_VALUE ? 0 : minm, maxm == Integer.MIN_VALUE ? 0 : maxm, avg, Math.sqrt(var)});
        this.acr.setFloatParm(12375, (float)this.config.ppu());
        this.acr.sendStr("axis0 slm (" + this.config.posSoftLimit() + "," + this.config.negSoftLimit() + ")", 0);
        this.blade.disableDrive();
    }

    private void procHome(int found, Object[] args) {
        int optns = (found & 1) != 0 ? (Integer)args[0] : 0;
        double vel = (found & 2) != 0 ? (Double)args[1] : 10.0;
        this.blade.home(optns, vel);
    }

    private void procPulse(int found, Object[] args) {
        double freq = (Double)args[0];
        if (freq != 0.0) {
            double fract;
            Pulse pulse = new Pulse();
            pulse.oLine = (found & 2) != 0 ? (Integer)args[1] : this.dioOLine;
            pulse.mCount = (found & 4) != 0 ? (Integer)args[2] : -1;
            double d = fract = (found & 8) != 0 ? (Double)args[3] : 0.5;
            if (freq < 2.0) {
                freq = 2.0;
            }
            if (freq > 10000.0) {
                freq = 10000.0;
            }
            if (fract > 1.0) {
                fract = 1.0;
            }
            pulse.width = fract / freq;
            if (pulse.width < (double)1.0E-5f) {
                pulse.width = 1.0E-5f;
            }
            pulse.count = 0;
            this.hel.cntrConfig((float)freq, false);
            this.hel.cntrEnable((Object)this, "genPulse", (Object)pulse);
            this.hel.cntrStart();
        } else {
            this.hel.cntrStop();
            this.hel.cntrDisable();
        }
    }

    private void procTimesync(int found, Object[] args) {
        boolean useCapt = (found & 1) != 0 ? (Integer)args[0] != 0 : false;
        int count = (found & 2) != 0 ? (Integer)args[1] : 10;
        this.acr.clearBit(33);
        this.acd.dioClrBit(this.dioOPort, this.dioOLine);
        BladeSetDrvr.Hall hall = new BladeSetDrvr.Hall(2 * count);
        hall.state = this.acd.dioInpBit(this.dioIPort, this.dioILine);
        this.acd.attachInt(1 << this.dioIPort, (Object)this, "readACR", (Object)hall);
        if ((count & 1) != 0) {
            ++count;
        }
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(1)", 0);
        this.acr.sendStr("dim la0(" + count + ")", 0);
        this.acr.sendStr("lv0 = 0", 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("while (lv0 < " + count + ")", 0);
        this.acr.sendStr("intcap axis0 10", 0);
        this.acr.sendStr("set 33", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh 4", 0);
        }
        this.acr.sendStr("la0(lv0) = p6916", 0);
        this.acr.sendStr("lv0 = lv0 + 1", 0);
        this.acr.sendStr("intcap axis0 14", 0);
        this.acr.sendStr("clr 33", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh -4", 0);
        }
        this.acr.sendStr("la0(lv0) = p6916", 0);
        this.acr.sendStr("lv0 = lv0 + 1", 0);
        this.acr.sendStr("wend", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.acr.clearBit(129);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        this.acr.sendStr("inh -129", 0);
        this.acd.detachInt();
        int[] vals = new int[1];
        this.acr.getVars(2, 0, 1, vals);
        int cCount = vals[0];
        int[] times = new int[cCount];
        this.acr.getVars(2, 0, 0, vals[0], times);
        this.out.format("Counts: requested = %s, controller = %s, computer = %s\n", new Object[]{count, cCount, hall.count});
        int pCTime = times[0];
        long pHTime = hall.data[0].time;
        count = cCount > hall.count ? cCount : hall.count;
        for (int j = 0; j < count; ++j) {
            if (j < cCount) {
                this.out.format("%4s", new Object[]{times[j] - pCTime});
                pCTime = times[j];
            } else {
                this.out.format("    ", new Object[0]);
            }
            if (j < hall.count) {
                BladeSetDrvr.HallItem item = hall.data[j];
                long hTime = item.time;
                this.out.format("  %4s  %s", new Object[]{(hTime - pHTime) / 1000000L, item.open ? "O" : "C"});
                pHTime = hTime;
            }
            this.out.println();
        }
    }

    private void procTempshow(int found, Object[] args) {
        this.out.format("Drive temperature: %.2f, Ambient temperature: %.2f\n", new Object[]{this.blade.getDriveTemperature(), this.blade.getAmbientTemperature()});
    }

    private void procThrshow(int found, Object[] args) {
        Thread[] threads = new Thread[Thread.activeCount()];
        int nThread = Thread.enumerate(threads);
        this.out.println((Object)"Thread information:");
        for (int j = 0; j < nThread; ++j) {
            this.out.println((Object)("  " + threads[j]));
        }
    }

    private void calTest(double dist, double time, String file) {
        BladeSetCalibration calData = this.blade.calibNew(dist, time);
        this.showStop(calData.getStatus());
        BladeSetConfiguration.writeCalibration((BladeSetCalibration)calData, (String)file);
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest1(boolean useCapt, double dist, double time, String file) {
        int sTime;
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int mCount = 64;
        double freq = (double)mCount / (2.0 * time);
        Pulse pulse = new Pulse();
        pulse.mCount = 2 * mCount;
        pulse.width = 0.5 / freq;
        pulse.oLine = this.dioOLine;
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(5)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("dim la1(100)", 0);
        this.acr.sendStr("dim la2(100)", 0);
        this.acr.sendStr("dim la3(100)", 0);
        this.acr.sendStr("dim la4(100)", 0);
        this.acr.sendStr("lv1 = 0", 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("lv2 = p6916", 0);
        this.acr.sendStr("for lv0 = 0 to " + (mCount - 1) + " step 1", 0);
        this.acr.sendStr("if (lv1 = 0)", 0);
        this.acr.sendStr("intcap axis0 10", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh 4", 0);
        }
        this.acr.sendStr("else", 0);
        this.acr.sendStr("intcap axis0 14", 0);
        if (useCapt) {
            this.acr.sendStr("inh 777", 0);
        } else {
            this.acr.sendStr("inh -4", 0);
        }
        this.acr.sendStr("endif", 0);
        this.acr.sendStr("la0(lv0) = p6916", 0);
        this.acr.sendStr("la3(lv0) = p6144", 0);
        this.acr.sendStr("la1(lv0) = p4096", 0);
        this.acr.sendStr("la2(lv0) = p4120", 0);
        this.acr.sendStr("la4(lv0) = p12292", 0);
        this.acr.sendStr("lv1 = 1 - lv1", 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("endp", 0);
        this.hel.cntrConfig((float)freq, false);
        this.hel.cntrEnable((Object)this, "genPulse", (Object)pulse);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        this.hel.cntrStart();
        if (dist != 0.0) {
            this.blade.move(0, dist, time, 0.0);
        } else {
            this.sleep(time);
        }
        this.acr.sendStr("inh -129", 0);
        this.acr.sendStr("intcap axis0 off", 0);
        this.hel.cntrStop();
        this.hel.cntrDisable();
        int[] vals = new int[3];
        this.acr.getVars(2, 0, 3, vals);
        int count = vals[0];
        int[] times = new int[count];
        int[] inpts = new int[count];
        int[] flags = new int[count];
        int[] posns = new int[count];
        int[] capts = new int[count];
        this.acr.getVars(2, 0, 0, count, times);
        this.acr.getVars(2, 1, 0, count, inpts);
        this.acr.getVars(2, 2, 0, count, flags);
        this.acr.getVars(2, 3, 0, count, posns);
        this.acr.getVars(2, 4, 0, count, capts);
        this.out.format("Capture count = %s, pulse count = %s\n", new Object[]{count, 2 * pulse.count});
        int pTime = sTime = vals[2];
        for (int j = 0; j < count; ++j) {
            ofl.format("%5s %5s %1s %1s %8.2f %6s %8.2f %6s\n", times[j] - sTime, times[j] - pTime, inpts[j] >> 4 & 1, flags[j] >> 9 & 1, this.config.position(posns[j]), posns[j], this.config.position(capts[j]), capts[j]);
            pTime = times[j];
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest2(double dist, double time, String file) {
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int outLine = 33;
        this.acr.clearBit(outLine);
        int capMode = 10;
        Pulse pulse = new Pulse();
        pulse.mCount = 32;
        pulse.iLine = this.dioILine;
        pulse.oLine = this.dioOLine;
        pulse.width = time / (double)(2 * pulse.mCount);
        pulse.iState = this.acd.dioInpBit(this.dioIPort, pulse.iLine);
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        this.acd.attachInt(1 << this.dioIPort, (Object)this, "passDio", (Object)pulse);
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(2)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("dim la1(100)", 0);
        this.acr.sendStr("lv1 = " + capMode, 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("lv2 = p6916", 0);
        this.acr.sendStr("for lv0 = 0 to " + (2 * pulse.mCount - 1) + " step 1", 0);
        this.acr.sendStr("intcap axis0 (lv1)", 0);
        this.acr.sendStr("if (lv1 = " + capMode + ") then set " + outLine, 0);
        this.acr.sendStr("if (lv1 <> " + capMode + ") then clr " + outLine, 0);
        this.acr.sendStr("inh 777", 0);
        this.acr.sendStr("la1(lv0) = p6916", 0);
        this.acr.sendStr("la0(lv0) = p12292", 0);
        this.acr.sendStr("lv1 = 24 - lv1", 0);
        this.acr.sendStr("dwl " + pulse.width, 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        if (dist != 0.0) {
            this.blade.move(0, dist, time, 0.0);
        } else {
            this.sleep(time);
        }
        this.acr.sendStr("halt prog2", 0);
        this.acr.sendStr("intcap axis0 off", 0);
        this.acd.detachInt();
        int[] vals = new int[3];
        this.acr.getVars(2, 0, 3, vals);
        int count = vals[0];
        int[] posns = new int[count];
        int[] times = new int[count];
        this.acr.getVars(2, 0, 0, count, posns);
        this.acr.getVars(2, 1, 0, count, times);
        this.out.format("Capture count = %s, transition count = %s (%s)\n", new Object[]{count, pulse.count, count == pulse.count ? "ok" : "mismatch"});
        int pTime = vals[2];
        for (int j = 0; j < count; ++j) {
            ofl.format("%5s %5s %8.2f %6s\n", times[j] - vals[2], times[j] - pTime, this.config.position(posns[j]), posns[j]);
            pTime = times[j];
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void calTest4(double dist, double time, String file) {
        PrintStream ofl;
        try {
            ofl = new PrintStream(file);
        }
        catch (IOException e) {
            this.out.println((Object)e);
            return;
        }
        int outLine = 33;
        this.acr.clearBit(outLine);
        Pulse pulse = new Pulse();
        pulse.mCount = 32;
        pulse.iLine = this.dioILine;
        pulse.oLine = this.dioOLine;
        pulse.width = time / (double)(2 * pulse.mCount);
        pulse.iState = this.acd.dioInpBit(this.dioIPort, pulse.iLine);
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        this.acd.attachInt(1 << this.dioIPort, (Object)this, "passDio", (Object)pulse);
        double delay = 0.009f;
        double ohead = 0.005f;
        this.acr.sendStr("prog2", 0);
        this.acr.sendStr("new prog2", 0);
        this.acr.sendStr("program", 0);
        this.acr.sendStr("clear", 0);
        this.acr.sendStr("dim lv(10)", 0);
        this.acr.sendStr("dim la(2)", 0);
        this.acr.sendStr("dim la0(100)", 0);
        this.acr.sendStr("dim la1(100)", 0);
        this.acr.sendStr("lv1 = 0", 0);
        this.acr.sendStr("set 129", 0);
        this.acr.sendStr("lv2 = p6916", 0);
        this.acr.sendStr("for lv0 = 0 to " + (2 * pulse.mCount - 1) + " step 1", 0);
        this.acr.sendStr("if (lv1 = 0) then set " + outLine, 0);
        this.acr.sendStr("if (lv1 <> 0) then clr " + outLine, 0);
        this.acr.sendStr("dwl " + delay, 0);
        this.acr.sendStr("la1(lv0) = p6916", 0);
        this.acr.sendStr("la0(lv0) = p4096", 0);
        this.acr.sendStr("lv1 = 1 - lv1", 0);
        this.acr.sendStr("dwl " + (pulse.width - delay - ohead), 0);
        this.acr.sendStr("next", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("endp", 0);
        this.acr.sendStr("sys", 0);
        this.acr.sendStr("clr 129", 0);
        this.acr.sendStr("run prog2", 0);
        this.acr.sendStr("inh 129", 0);
        if (dist != 0.0) {
            this.blade.move(0, dist, time, 0.0);
        } else {
            this.sleep(time);
        }
        this.acr.sendStr("inh -129", 0);
        this.acd.detachInt();
        int[] vals = new int[3];
        this.acr.getVars(2, 0, 3, vals);
        int count = vals[0];
        int[] inpts = new int[count];
        int[] times = new int[count];
        this.acr.getVars(2, 0, 0, count, inpts);
        this.acr.getVars(2, 1, 0, count, times);
        this.out.format("Capture count = %s, transition count = %s (%s)\n", new Object[]{count, pulse.count, count == pulse.count ? "ok" : "mismatch"});
        int pTime = vals[2];
        for (int j = 0; j < count; ++j) {
            ofl.format("%5s %5s %08x\n", times[j] - vals[2], times[j] - pTime, inpts[j]);
            pTime = times[j];
        }
        ofl.close();
        this.out.println((Object)("File " + file + " created"));
    }

    private void writePosnData(MovementHistory data, PrintStream ofl) {
        long sTime = data.getStartTime() / 1000L;
        List pList = data.getPositions();
        for (int j = 0; j < pList.size(); ++j) {
            BladePosition pItem = (BladePosition)pList.get(j);
            long pTime = pItem.getTime() / 1000L;
            ofl.format("%12s %5s %8.2f %8.5f\n", pTime, pTime - sTime, pItem.getPosition(), pItem.getRelPosition());
        }
    }

    private void writeHallData(MovementHistory data, PrintStream ofl) {
        long sTime = data.getStartTime() / 1000L;
        List hList = data.getHallTransitions();
        for (int j = 0; j < hList.size(); ++j) {
            HallTransition hItem = (HallTransition)hList.get(j);
            long hTime = (hItem.getTransitionTime() + 500L) / 1000L;
            ofl.format("%12s %5s %s %s %s %8.2f %8.5f\n", hTime, hTime - sTime, hItem.getSensorId(), hItem.isOpen() ? "O" : "C", hItem.isReverse() ? "-" : "+", hItem.getPosition(), hItem.getRelPosition());
        }
    }

    private String genFileName(String head, String tail, long tStamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(tStamp);
        return head + this.bladeIndex + "_" + String.format("%tY%<tm%<td_%<tH%<tM%<tS", cal) + tail;
    }

    private String genFileName(String head, String tail) {
        return this.genFileName(head, tail, System.currentTimeMillis());
    }

    private void showMoveStart(double posn, long time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(time);
        this.out.format("Started move: posn = %8.2f, time = %tF %<tT.%<tL\n", new Object[]{posn, cal});
    }

    private void showMoveStart() {
        this.showMoveStart(this.blade.getPosition(), System.currentTimeMillis());
    }

    private void showMoveEnd(double posn, long time) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(time);
        this.out.format("Ended move  : posn = %8.2f, time = %tF %<tT.%<tL\n", new Object[]{posn, cal});
    }

    private void showMoveEnd() {
        this.showMoveEnd(this.blade.getPosition(), System.currentTimeMillis());
    }

    private void showPosition() {
        int posn = this.acr.getIntParm(6144);
        this.out.format("Position = %.2f mm (encoder = %s)\n", new Object[]{this.config.position(posn), posn});
    }

    private void showRelPosition() {
        this.out.format("Relative position = %.5f\n", new Object[]{this.blade.getCurrentPosition()});
    }

    private String showStop(int status) {
        String stopped = this.getStop(status);
        if (stopped != null) {
            this.out.println((Object)stopped);
        }
        return stopped;
    }

    private String showStop() {
        return this.showStop(this.blade.moveStatus());
    }

    private String getStop(int status) {
        if (status == 0) {
            return null;
        }
        return MovementStatus.message(status);
    }

    private String getStop() {
        return this.getStop(this.blade.moveStatus());
    }

    private void genPulse(int value, Object parm) {
        Pulse pulse = (Pulse)parm;
        if (pulse.count >= pulse.mCount) {
            return;
        }
        this.acd.dioSetBit(this.dioOPort, pulse.oLine);
        this.sleep(pulse.width);
        this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        ++pulse.count;
    }

    private void passDio(int value, Object parm) {
        Pulse pulse = (Pulse)parm;
        int state = this.acd.dioInpBit(this.dioIPort, pulse.iLine);
        if (state == pulse.iState) {
            return;
        }
        pulse.iState = state;
        ++pulse.count;
        if (state != 0) {
            this.acd.dioClrBit(this.dioOPort, pulse.oLine);
        } else {
            this.acd.dioSetBit(this.dioOPort, pulse.oLine);
        }
    }

    private void readACR(int value, Object parm) {
        boolean open;
        BladeSetDrvr.Hall hall = (BladeSetDrvr.Hall)parm;
        int state = this.acd.dioInpBit(this.dioIPort, this.dioILine);
        if (state == hall.state) {
            return;
        }
        hall.state = state;
        boolean bl = open = state != 0;
        if (!open) {
            this.acd.dioSetBit(this.dioOPort, this.dioOLine);
        } else {
            this.acd.dioClrBit(this.dioOPort, this.dioOLine);
        }
        if (hall.count >= hall.data.length) {
            return;
        }
        BladeSetDrvr.HallItem item = hall.data[hall.count++];
        item.time = System.nanoTime();
        item.open = open;
    }

    private void sleep(double secs) {
        long nsecs = (long)(1.0E9 * secs);
        try {
            Thread.sleep(nsecs / 1000000L, (int)(nsecs % 1000000L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        moveTypes.add("scurve", 0);
        moveTypes.add("trap", 1);
        driveTypes = new CmndProcess.Lookup(2);
        driveTypes.add("on", 1);
        driveTypes.add("off", 0);
        cmnd = new CmndProcess.Command(21);
        cmnd.add("confshow", 19, helpConfshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("drive", 15, helpDrive, "K", new CmndProcess.Lookup[]{driveTypes});
        cmnd.add("calibrate", 0, helpCalib, "DDds", new CmndProcess.Lookup[0]);
        cmnd.add("caltest", 10, helpCaltest, "IDds", new CmndProcess.Lookup[0]);
        cmnd.add("calread", 7, helpCalread, "s", new CmndProcess.Lookup[0]);
        cmnd.add("calshow", 8, helpCalshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("position", 18, helpPosition, "dds", new CmndProcess.Lookup[0]);
        cmnd.add("move", 3, helpMove, "ddkd", new CmndProcess.Lookup[]{moveTypes});
        cmnd.add("moved", 6, helpMoved, "ddikds", new CmndProcess.Lookup[]{moveTypes});
        cmnd.add("movep", 4, helpMovep, "ddikds", new CmndProcess.Lookup[]{moveTypes});
        cmnd.add("movex", 11, helpMovex, "ddikds", new CmndProcess.Lookup[]{moveTypes});
        cmnd.add("moveh", 5, helpMoveh, "ddikds", new CmndProcess.Lookup[]{moveTypes});
        cmnd.add("movetest", 16, helpMovetest, "IDd", new CmndProcess.Lookup[0]);
        cmnd.add("halltest", 14, helpHalltest, "IDds", new CmndProcess.Lookup[0]);
        cmnd.add("enctest", 17, helpEnctest, "IDdis", new CmndProcess.Lookup[0]);
        cmnd.add("step", 1, helpStep, "IId", new CmndProcess.Lookup[0]);
        cmnd.add("home", 2, helpHome, "id", new CmndProcess.Lookup[0]);
        cmnd.add("pulse", 9, helpPulse, "Diid", new CmndProcess.Lookup[0]);
        cmnd.add("tempshow", 20, helpTempshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("thrshow", 12, helpThrshow, "", new CmndProcess.Lookup[0]);
        cmnd.add("timesync", 13, helpTimesync, "ii", new CmndProcess.Lookup[0]);
    }

    public static class Pulse {
        int mCount;
        int count;
        int oLine;
        int iLine;
        int iState;
        double width;
    }
}

