/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystems.shutter;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.framework.Module;
import org.lsst.ccs.subsystems.shutter.common.BladeSet;
import org.lsst.ccs.subsystems.shutter.common.MovementHistory;
import org.lsst.ccs.subsystems.shutter.status.BladePositionResult;
import org.lsst.ccs.subsystems.shutter.status.CloseShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.MoveToPositionStatus;
import org.lsst.ccs.subsystems.shutter.status.MovementHistoryStatus;
import org.lsst.ccs.subsystems.shutter.status.OpenShutterStatus;
import org.lsst.ccs.subsystems.shutter.status.ReadyForActionStatus;
import org.lsst.ccs.subsystems.shutter.status.StatusKey;
import org.lsst.ccs.subsystems.shutter.status.TakeExposureStatus;
import org.lsst.ccs.subsystems.shutter.status.UnsafeMoveStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class ShutterModule
extends Module {
    @ConfigurationParameter(name="bladeMovementTime", description="The duration in seconds of any blade set motion")
    private volatile double bladeMovementTime;
    @ConfigurationParameter(name="bladeSetEndTol", description="Tolerance, as relative position, for deciding whether a blade set is at its opened or closed position")
    private volatile double bladeSetEndTol;
    @ConfigurationParameter(name="bladeSetApproachMin", description="The minimum distance, as relative position, to keep between the blade set edges")
    private volatile double bladeSetApproachMin;
    private final List<BladeSet> bladeSets;
    private final Logger mylog = Logger.getLogger((String)"org.lsst.ccs.subsystem.shutter");
    private static final ScheduledExecutorService exec = Executors.newSingleThreadScheduledExecutor();

    public ShutterModule(String name, List<BladeSet> bladeSets) {
        super(name);
        this.bladeSets = bladeSets;
        this.bladeMovementTime = 1.0;
        this.bladeSetEndTol = 0.001;
        this.bladeSetApproachMin = 0.001;
    }

    public void initModule() {
        this.mylog.info((Object)"[ShutterModule] Initializing the Shutter module ");
        if (this.bladeSets.size() != 2) {
            this.logFatalMessageAndThrowException("[ShutterModule] The Shutter Module requires two bladeSets when built");
        }
    }

    public void start() {
        this.getBladeSet(0).init();
        this.getBladeSet(1).init();
    }

    public void shutdownNow() {
        super.shutdownNow();
        exec.shutdown();
    }

    public final BladeSet getBladeSet(int index) {
        return this.bladeSets.get(index);
    }

    public double getBladeMovementTime() {
        return this.bladeMovementTime;
    }

    public double getBladeSetEndTol() {
        return this.bladeSetEndTol;
    }

    public double getBladeSetApproachMin() {
        return this.bladeSetApproachMin;
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Gets the current relative positions of both blade sets")
    public BladePositionResult getBladeSetPositions() {
        return new BladePositionResult(this.getBladeSet(0).getCurrentPosition(), this.getBladeSet(1).getCurrentPosition());
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Moves one of the blade sets")
    public void moveToPosition(@Argument(name="index", description="The blade set index (0 or 1)") int index, @Argument(name="targetPosition", description="The desired relative position of the blade set") double targetPosition) {
        if (this.moveIsUnsafe(index, targetPosition)) {
            this.publish(StatusKey.UNSAFE_MOVE, (Serializable)new UnsafeMoveStatus());
        } else {
            this.publish(StatusKey.MOVE_BLADE_SET, (Serializable)new MoveToPositionStatus(this.getBladeSet(index).getCurrentPosition(), index, targetPosition, this.getBladeMovementTime()));
            MovementHistory hist = this.getBladeSet(index).moveToPosition(targetPosition, this.getBladeMovementTime());
            this.publish(StatusKey.MOVEMENT, (Serializable)new MovementHistoryStatus(true, true, hist));
        }
        this.publish(StatusKey.READY, (Serializable)new ReadyForActionStatus(true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveTwoBladeSets(int ifirst, double firstTargetPosition, double secondTargetPosition, double secondStartDelay) {
        BladeSet first = this.getBladeSet(ifirst);
        BladeSet second = this.getBladeSet(1 - ifirst);
        ScheduledFuture<MovementHistory> fuhist1 = exec.schedule(() -> first.moveToPosition(firstTargetPosition, this.bladeMovementTime), 0L, TimeUnit.MILLISECONDS);
        ScheduledFuture<MovementHistory> fuhist2 = exec.schedule(() -> second.moveToPosition(secondTargetPosition, this.bladeMovementTime), Math.round(1000.0 * secondStartDelay), TimeUnit.MILLISECONDS);
        try {
            MovementHistory hist1 = (MovementHistory)fuhist1.get();
            this.publish(StatusKey.MOVEMENT, (Serializable)new MovementHistoryStatus(true, false, hist1));
            MovementHistory hist2 = (MovementHistory)fuhist2.get();
            this.publish(StatusKey.MOVEMENT, (Serializable)new MovementHistoryStatus(false, true, hist2));
        }
        catch (InterruptedException e) {
            fuhist1.cancel(true);
            fuhist2.cancel(true);
        }
        catch (ExecutionException e) {
            fuhist1.cancel(true);
            fuhist2.cancel(true);
            ShutterModule.launderThrowable(e.getCause());
        }
        finally {
            this.publish(StatusKey.READY, (Serializable)new ReadyForActionStatus(true));
        }
    }

    @Command(type=Command.CommandType.ACTION, level=0, description="Performs a timed exposure (open, wait, close)")
    public void takeExposure(@Argument(name="exposureTime", description="The duration of the exposure in seconds") double exposureTime) {
        BladePositionResult pos = this.getBladeSetPositions();
        int ifirst = pos.getPos0() > pos.getPos1() ? 0 : 1;
        this.publish(StatusKey.TAKE_EXPOSURE, (Serializable)new TakeExposureStatus(ifirst, this.bladeMovementTime, exposureTime));
        this.moveTwoBladeSets(ifirst, 0.0, 1.0, exposureTime);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Closes the shutter")
    public void closeShutter() {
        this.publish(StatusKey.CLOSE_SHUTTER, (Serializable)new CloseShutterStatus(0, this.getBladeMovementTime()));
        this.moveTwoBladeSets(0, 0.0, 1.0, this.bladeMovementTime);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Opens the shutter")
    public void openShutter() {
        this.publish(StatusKey.OPEN_SHUTTER, (Serializable)new OpenShutterStatus(0, this.getBladeMovementTime()));
        this.moveTwoBladeSets(0, 0.0, 0.0, this.bladeMovementTime);
    }

    @Command(type=Command.CommandType.ACTION, level=1, description="Performs a shutter motion calibration")
    public void calibrate() {
        this.publish(StatusKey.READY, (Serializable)new ReadyForActionStatus(true));
    }

    private static void launderThrowable(Throwable thr) {
        if (thr instanceof RuntimeException) {
            throw (RuntimeException)thr;
        }
        if (thr instanceof Error) {
            throw (Error)thr;
        }
        throw new IllegalStateException("Not unchecked", thr);
    }

    private void logFatalMessageAndThrowException(String msg) {
        this.mylog.fatal((Object)msg);
        throw new RuntimeException(msg);
    }

    private void publish(StatusKey key, Serializable status) {
        this.getSubsystem().publishSubsystemDataOnStatusBus(new KeyValueData(key.getKey(), status));
    }

    private boolean bladeSetIsRetracted(int index) {
        return Math.abs(this.getBladeSet(index).getCurrentPosition()) < this.getBladeSetEndTol();
    }

    private boolean bladeSetIsExtended(int index) {
        return Math.abs(1.0 - this.getBladeSet(index).getCurrentPosition()) < this.getBladeSetEndTol();
    }

    private boolean moveIsUnsafe(int index, double targetPosition) {
        return 1.0 - targetPosition - this.getBladeSet(1 - index).getCurrentPosition() <= this.getBladeSetApproachMin();
    }
}

