package org.lsst.ccs.subsystems.shutter.parker;

/**
 ***************************************************************************
 **
 **  Class containing movement status codes and messages
 **
 **  @author Owen Saxton
 **
 ***************************************************************************
 */
public class MovementStatus {

    public final static int STS_NORMAL           = 0,
                            STS_POS_EOT_LIMIT    = 1,
                            STS_NEG_EOT_LIMIT    = 2,
                            STS_POS_SOFT_LIMIT   = 3,
                            STS_NEG_SOFT_LIMIT   = 4,
                            STS_EXCS_POSN_ERROR  = 5,
                            STS_UNKN_MOVE_TRUNC  = 6,
                            STS_MSSG_PGM_VBLES   = 7,
                            STS_EXCESS_HALL_TRAN = 8,
                            STS_UNEQL_HALL_TRAN  = 9,
                            STS_INSUFF_VBLE_MEM  = 10,
                            STS_INSUFF_USER_PARM = 11;


    public static String message(int code)
    {
        switch (code) {

        case STS_NORMAL:
            return "Success";

        case STS_POS_EOT_LIMIT:
            return "Positive EOT limit reached";

        case STS_NEG_EOT_LIMIT:
            return "Negative EOT limit reached";

        case STS_POS_SOFT_LIMIT:
            return "Positive soft limit reached";

        case STS_NEG_SOFT_LIMIT:
            return "Negative soft limit reached";

        case STS_EXCS_POSN_ERROR:
            return "Excess position error";

        case STS_UNKN_MOVE_TRUNC:
            return "Unidentified move truncation";

        case STS_MSSG_PGM_VBLES:
            return "Expected program variables not found";

        case STS_EXCESS_HALL_TRAN:
            return "Too many Hall transitions";

        case STS_UNEQL_HALL_TRAN:
            return "Hall transition and capture count mismatch";

        case STS_INSUFF_VBLE_MEM:
            return "Insufficient memory for requested captures";

        case STS_INSUFF_USER_PARM:
            return "Insufficient user parameters";
        }

        return "Unknown status code: " + code;
    }

}
