import static org.lsst.gruth.jutils.MapArgs.*
import org.lsst.ccs.subsystems.shutter.common.BladeSet
import org.lsst.ccs.description.groovy.CCSBuilder
import org.lsst.ccs.subsystems.shutter.ShutterModule
import org.lsst.ccs.subsystems.shutter.sim.BladeSetSimulator


static List<BladeSet> buildSimulatedBladeSets() {
    List<BladeSet> bladeSets = new ArrayList(2)
    for (int ix in 0..1) {
        bladeSets.add(new BladeSetSimulator(ix))
    }
    return bladeSets
}
    
static Object buildDescription(
    final List<BladeSet> bladeSets)
{
    CCSBuilder builder = ['ccs-shutter']
    return builder.main(ShutterModule, argMap("main", bladeSets))
}

return buildDescription(buildSimulatedBladeSets());
