package org.lsst.ccs.subsystems.shutter.interfaces;

import org.lsst.ccs.subsystems.shutter.driver.BladeSetConfiguration;

public interface BladeSet {


    /**
     * Get the current position of the BladeSet
     *
     * @return  The current position of the BladeSet, a number in the fuzzy
     *          range [0,1].
     *
     */
    public float getCurrentPosition();


    /**
     * Move the blade set to the specified position
     *
     * @param position  Position of the leading blade to move to.
     *                  This is a number [0,1] where 0 means fully open and
     *                  1 is fully closed.
     *
     * @param moveTime  How long it should take in seconds reach the position.
     *
     * @throws IllegalArgumentException if the position is not in [0,1].
     *
     */
    public void moveToPosition(float position, float moveTime)
             throws IllegalArgumentException;

    /**
     * 
     * @return The movement history
     */
//    public MovementHistory getMovementHistory();


      public void addMovementHistoryListener(MovementHistoryListener l);
      public void removeMovementHistoryListener(MovementHistoryListener l);

      public void addHallSensorListener(HallSensorListener l);
      public void removeHallSensorListener(HallSensorListener l);

    /**
     * Set the index of the BladeSet
     *
     * This specifies which BladeSet is being used and causes it to be
     * initialized with its set of configuration parameters.
     *
     */
    public void setIndex(int index);

    public int getIndex();

    /**
     * Get the configuration of the BladeSet.
     *
     * @return  The BladeSet configuration.
     *
     */
    public BladeSetConfiguration getBladeSetConfiguration();




}
