/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.text.DecimalFormat;
import java.text.Format;
import plotter.AxisLabeler;
import plotter.ContinuousAxisModel;

public class SimpleAxisLabeler
implements AxisLabeler {
    private int nLabels = 10;
    private Format format = new DecimalFormat();
    private ContinuousAxisModel model;

    SimpleAxisLabeler(ContinuousAxisModel model) {
        this.model = model;
    }

    @Override
    public int getNLabels() {
        return this.nLabels;
    }

    @Override
    public String getLabel(int index) {
        return this.format.format(this.model.getModelCoordinateFromAxisCoordinate(this.getLabelPos(index)));
    }

    @Override
    public float getLabelPos(int index) {
        return (float)index / ((float)this.nLabels - 1.0f);
    }

    @Override
    public int getNTickMarks() {
        return this.getNLabels();
    }

    @Override
    public float getTickPos(int index) {
        return this.getLabelPos(index);
    }

    @Override
    public int getNMinorTickMarks() {
        return 0;
    }

    @Override
    public float getMinorTickPos(int index) {
        return 0.0f;
    }

    @Override
    public String getToolTipText(float pos) {
        return this.format.format(this.model.getModelCoordinateFromAxisCoordinate(pos));
    }

    @Override
    public String getAxisUnit() {
        return null;
    }
}

