/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.motorplatform.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.lsst.ccs.subsystem.motorplatform.bus.ClearAllFaults;
import org.lsst.ccs.subsystem.motorplatform.bus.ControllerStatus;
import org.lsst.ccs.subsystem.motorplatform.bus.EnableAllAxes;
import org.lsst.ccs.subsystem.motorplatform.bus.MotorCommandListener;
import org.lsst.ccs.subsystem.motorplatform.bus.PlatformConfig;
import org.lsst.ccs.subsystem.motorplatform.bus.StopAllMotion;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusEvent;
import org.lsst.ccs.subsystem.motorplatform.gui.TargetStatusListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ControllerPanel
extends JPanel
implements TargetStatusListener {
    private static final Logger LOG = Logger.getLogger(ControllerPanel.class.getName());
    private MotorCommandListener sender;
    private JButton clearFaultsButton;
    private JLabel commStatus;
    private JLabel commandStatus;
    private JLabel configName;
    private JButton enableAxesButton;
    private JLabel enableStatus;
    private JLabel jLabel1;
    private JButton stopMotionButton;

    public ControllerPanel() {
        this.initComponents();
        this.sender = null;
    }

    public void init(MotorCommandListener sender) {
        this.sender = sender;
    }

    public void configure(PlatformConfig config) {
        this.configName.setText("Configuration: " + config.getConfigName());
        this.commStatus.setText("Comm link: ?");
        this.commandStatus.setText("Command status: ?");
        this.enableStatus.setText("Motion enabled: ?");
    }

    public void update(ControllerStatus status) {
        this.commStatus.setText("Comm link: " + status.getCommLinkStatus());
        this.commandStatus.setText("Command status: " + status.getLastCommandStatus());
        this.enableStatus.setText("Motion enabled: " + (status.isMotionEnabled() ? "YES" : "NO"));
    }

    @Override
    public void handleTargetStatusEvent(TargetStatusEvent evt) {
        this.clearFaultsButton.setEnabled(!evt.disableCommands());
        this.enableAxesButton.setEnabled(!evt.disableCommands());
        this.stopMotionButton.setEnabled(!evt.disableCommands());
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.commStatus = new JLabel();
        this.enableStatus = new JLabel();
        this.configName = new JLabel();
        this.commandStatus = new JLabel();
        this.clearFaultsButton = new JButton();
        this.enableAxesButton = new JButton();
        this.stopMotionButton = new JButton();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setFont(new Font("DejaVu LGC Sans", 3, 13));
        this.jLabel1.setHorizontalAlignment(0);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.jLabel1.text"));
        this.commStatus.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.commStatus, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.commStatus.text"));
        this.enableStatus.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.enableStatus, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.enableStatus.text"));
        this.configName.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.configName, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.configName.text"));
        this.commandStatus.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((JLabel)this.commandStatus, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.commandStatus.text"));
        this.clearFaultsButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.clearFaultsButton, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.clearFaultsButton.text"));
        this.clearFaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerPanel.this.handleClearFaults(evt);
            }
        });
        this.enableAxesButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.enableAxesButton, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.enableAxesButton.text"));
        this.enableAxesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerPanel.this.handleEnableAxes(evt);
            }
        });
        this.stopMotionButton.setFont(new Font("DejaVu LGC Sans", 1, 13));
        Mnemonics.setLocalizedText((AbstractButton)this.stopMotionButton, (String)NbBundle.getMessage(ControllerPanel.class, (String)"ControllerPanel.stopMotionButton.text"));
        this.stopMotionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControllerPanel.this.handleStopMotion(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.configName).addComponent(this.enableStatus).addComponent(this.commStatus).addComponent(this.commandStatus).addGroup(layout.createSequentialGroup().addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.clearFaultsButton, -1, -1, Short.MAX_VALUE).addComponent(this.enableAxesButton, -1, -1, Short.MAX_VALUE).addComponent(this.stopMotionButton, -1, -1, Short.MAX_VALUE)))).addGap(0, 17, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.commStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableStatus).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.configName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandStatus).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.clearFaultsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableAxesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopMotionButton).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void handleClearFaults(ActionEvent evt) {
        this.sender.clearAllFaults(new ClearAllFaults());
    }

    private void handleEnableAxes(ActionEvent evt) {
        this.sender.enableAllAxes(new EnableAllAxes());
    }

    private void handleStopMotion(ActionEvent evt) {
        this.sender.stopAllMotion(new StopAllMotion());
    }
}

