/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.awt.Color;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.freehep.util.Value;
import plotter.Axis;
import plotter.ByteAxisLabeler;
import plotter.DataArea;
import plotter.LineChartOverlay;
import plotter.LinearAxisModel;
import plotter.PlotLayout;
import plotter.TestFrame;
import util.ListenerList;

public class MemoryTest
implements PlotDataListener {
    private final MemoryUsageHistory memoryUsage = new MemoryUsageHistory();
    private final LinearAxisModel xAxisModel = new LinearAxisModel(0.0, 1.0);
    private final LinearAxisModel yAxisModel = new LinearAxisModel(0.0, 1.0);

    public static void main(String[] args) {
        MemoryTest app = new MemoryTest();
    }

    private MemoryTest() {
        this.memoryUsage.addPlotDataListener(this);
        Axis xAxis = new Axis(this.xAxisModel, Axis.AxisPosition.LEFT);
        xAxis.setLabeler(new ByteAxisLabeler(this.xAxisModel, xAxis.getLabelSizer()));
        Axis yAxis = new Axis(this.yAxisModel, Axis.AxisPosition.BOTTOM);
        DataArea da = new DataArea(yAxis, xAxis);
        LineChartOverlay heapOverlay = new LineChartOverlay("Heap", this.memoryUsage, 0, 1, this.yAxisModel, this.xAxisModel);
        da.add(heapOverlay);
        LineChartOverlay nonHeapOverlay = new LineChartOverlay("Non heap", this.memoryUsage, 0, 2, this.yAxisModel, this.xAxisModel);
        nonHeapOverlay.setLineColor(Color.BLUE);
        da.add(nonHeapOverlay);
        JPanel plotPanel = new JPanel(new PlotLayout());
        plotPanel.add(xAxis);
        plotPanel.add(yAxis);
        plotPanel.add(da);
        new TestFrame("Memory test", plotPanel);
    }

    @Override
    public void dataChanged() {
        SuggestedRange range = this.memoryUsage.getSuggestedRange();
        Value min1 = new Value();
        Value max1 = new Value();
        range.getMin(min1, 1);
        range.getMax(max1, 1);
        Value min2 = new Value();
        Value max2 = new Value();
        range.getMin(min2, 2);
        range.getMax(max2, 2);
        this.xAxisModel.setRange(Math.min(min1.getDouble(), min2.getDouble()), Math.max(max1.getDouble(), max2.getDouble()));
        range.getMin(min1, 0);
        range.getMax(max1, 0);
        this.yAxisModel.setRange(min1.getDouble(), max1.getDouble());
    }

    private static class MemoryUsageHistory
    implements DiscretePlotData,
    MutablePlotData,
    SuggestedRange {
        private final List<MemoryUsage> history = new ArrayList<MemoryUsage>();
        private final Timer timer = new Timer("MemoryHistoryTimer", true);
        private final long rate = 1000L;
        private final ListenerList<PlotDataListener> listeners = new ListenerList();
        private final String[] names = new String[]{"time", "heap", "non-heap"};
        private long minHeapMemoryUsage;
        private long maxHeapMemoryUsage;
        private long minNonheapMemoryUsage;
        private long maxNonheapMemoryUsage;

        MemoryUsageHistory() {
            this.timer.scheduleAtFixedRate((TimerTask)new MemoryUsageTask(), 1000L, 1000L);
        }

        @Override
        public int getNPoints() {
            return this.history.size();
        }

        @Override
        public int getNDimensions() {
            return this.names.length;
        }

        @Override
        public String names(int index) {
            return this.names[index];
        }

        @Override
        public Class types(int index) {
            return index == 0 ? Date.class : Long.TYPE;
        }

        @Override
        public void getValue(Value value, int dim, int index) {
            MemoryUsage memoryUsage = this.history.get(index);
            switch (dim) {
                case 0: {
                    value.set(memoryUsage.getDate());
                    return;
                }
                case 1: {
                    value.set(memoryUsage.getHeap());
                    return;
                }
                case 2: {
                    value.set(memoryUsage.getNonHeap());
                    return;
                }
            }
        }

        @Override
        public MetaData getMetaData() {
            return null;
        }

        @Override
        public String getTitle() {
            return "Memory Usage";
        }

        @Override
        public SuggestedRange getSuggestedRange() {
            return this;
        }

        @Override
        public void addPlotDataListener(PlotDataListener listener) {
            this.listeners.addListener(listener);
        }

        @Override
        public void removePlotDataListener(PlotDataListener listener) {
            this.listeners.removeListener(listener);
        }

        private void firePlotDataChanged() {
            if (!this.listeners.isEmpty()) {
                for (PlotDataListener l : this.listeners.getListeners()) {
                    l.dataChanged();
                }
            }
        }

        @Override
        public Object lock() {
            return this.history;
        }

        @Override
        public void getMin(Value value, int dimension) {
            switch (dimension) {
                case 0: {
                    value.set(this.history.get(0).getDate());
                    return;
                }
                case 1: {
                    value.set(this.minHeapMemoryUsage);
                    return;
                }
                case 2: {
                    value.set(this.minNonheapMemoryUsage);
                    return;
                }
            }
        }

        @Override
        public void getMax(Value value, int dimension) {
            switch (dimension) {
                case 0: {
                    value.set(this.history.get(this.history.size() - 1).getDate());
                    return;
                }
                case 1: {
                    value.set(this.maxHeapMemoryUsage);
                    return;
                }
                case 2: {
                    value.set(this.maxNonheapMemoryUsage);
                    return;
                }
            }
        }

        @Override
        public int affinity() {
            return 0;
        }

        private static class MemoryUsage {
            private Date date = new Date();
            private long heap;
            private long nonHeap;

            public MemoryUsage() {
                MemoryMXBean bean = ManagementFactory.getMemoryMXBean();
                this.heap = bean.getHeapMemoryUsage().getUsed();
                this.nonHeap = bean.getNonHeapMemoryUsage().getUsed();
            }

            public Date getDate() {
                return this.date;
            }

            public long getHeap() {
                return this.heap;
            }

            public long getNonHeap() {
                return this.nonHeap;
            }
        }

        private class MemoryUsageTask
        extends TimerTask {
            Runnable firePlotChanged = new Runnable(){

                @Override
                public void run() {
                    MemoryUsageHistory.this.firePlotDataChanged();
                }
            };

            private MemoryUsageTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                MemoryUsage memoryUsage = new MemoryUsage();
                List list = MemoryUsageHistory.this.history;
                synchronized (list) {
                    if (MemoryUsageHistory.this.history.isEmpty()) {
                        MemoryUsageHistory.this.minHeapMemoryUsage = (MemoryUsageHistory.this.maxHeapMemoryUsage = memoryUsage.getHeap());
                        MemoryUsageHistory.this.minNonheapMemoryUsage = (MemoryUsageHistory.this.maxNonheapMemoryUsage = memoryUsage.getNonHeap());
                    } else {
                        MemoryUsageHistory.this.minHeapMemoryUsage = Math.min(MemoryUsageHistory.this.minHeapMemoryUsage, memoryUsage.getHeap());
                        MemoryUsageHistory.this.maxHeapMemoryUsage = Math.max(MemoryUsageHistory.this.maxHeapMemoryUsage, memoryUsage.getHeap());
                        MemoryUsageHistory.this.minNonheapMemoryUsage = Math.min(MemoryUsageHistory.this.minNonheapMemoryUsage, memoryUsage.getNonHeap());
                        MemoryUsageHistory.this.maxNonheapMemoryUsage = Math.max(MemoryUsageHistory.this.maxNonheapMemoryUsage, memoryUsage.getNonHeap());
                    }
                    MemoryUsageHistory.this.history.add(memoryUsage);
                }
                SwingUtilities.invokeLater(this.firePlotChanged);
            }
        }
    }
}

