/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;

public final class BladesDisplay
extends JComponent {
    private static final int DISPLAY_WIDTH = 400;
    private static final int DISPLAY_HEIGHT = 500;
    private static final int BLADE_WIDTH = 400;
    private static final int BLADE_HEIGHT = 100;
    private static final int APERTURE_DIAMETER = 300;
    private static final int APERTURE_WIDTH_INSET = 50;
    private static final int APERTURE_HEIGHT_INSET = 100;
    private static final Color BLADE_FILL_COLOR = new Color(0.5f, 0.5f, 0.5f, 0.5f);
    private static final int AXIS_SIZE = 50;
    private static final int ARROWHEAD_SIZE = 5;
    private static final int AXIS_ORIGIN_OFFSET = 5;
    private static final int AXIS_LABEL_POS = 45;
    private static final int AXIS_LABEL_SEP = 15;
    private final Map<ShutterSide, BladeSet> shutters = new EnumMap<ShutterSide, BladeSet>(ShutterSide.class);

    public BladesDisplay() {
        Dimension dimension = new Dimension(400, 500);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.shutters.put(ShutterSide.PLUSX, new BladeSet(400, 100));
        this.shutters.put(ShutterSide.MINUSX, new BladeSet(400, 100));
        this.shutters.get(ShutterSide.PLUSX).setPosition(0.0f);
        this.shutters.get(ShutterSide.MINUSX).setPosition(1.0f);
    }

    BladeSet getShutter(ShutterSide side) {
        return this.shutters.get(side);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        g2.drawRect(0, 0, 400, 500);
        Arc2D.Float circle = new Arc2D.Float(50.0f, 100.0f, 300.0f, 300.0f, 0.0f, 360.0f, 1);
        g2.draw(circle);
        this.shutters.get(ShutterSide.PLUSX).paint(g2);
        g2.translate(0, 500);
        g2.scale(1.0, -1.0);
        this.shutters.get(ShutterSide.MINUSX).paint(g2);
        Graphics2D g3 = (Graphics2D)g.create();
        AffineTransform flip = AffineTransform.getScaleInstance(1.0, -1.0);
        g3.translate(0, 500);
        g3.transform(flip);
        g3.setFont(g3.getFont().deriveFont(flip));
        g3.addRenderingHints(hints);
        this.drawAxes(g3, 50.0, 5.0, 5.0, 5.0);
        g3.drawString("X", 15, 45);
        g3.drawString("Y", 45, 15);
    }

    private GeneralPath makeArrowhead() {
        GeneralPath head = new GeneralPath();
        head.moveTo(0.0, 0.0);
        head.lineTo(-1.0, -3.0);
        head.lineTo(1.0, -3.0);
        head.closePath();
        return head;
    }

    private GeneralPath makeAxes() {
        GeneralPath axes = new GeneralPath();
        axes.moveTo(0.0, 1.0);
        axes.lineTo(0.0, 0.0);
        axes.lineTo(1.0, 0.0);
        return axes;
    }

    private void drawAxes(Graphics2D g, double axisScale, double arrowScale, double x, double y) {
        GeneralPath axes = this.makeAxes();
        axes.transform(AffineTransform.getScaleInstance(axisScale, axisScale));
        axes.transform(AffineTransform.getTranslateInstance(x, y));
        g.draw(axes);
        GeneralPath xhead = this.makeArrowhead();
        xhead.transform(AffineTransform.getScaleInstance(arrowScale, arrowScale));
        xhead.transform(AffineTransform.getQuadrantRotateInstance(3));
        xhead.transform(AffineTransform.getTranslateInstance(axisScale + x + 2.0, y));
        g.fill(xhead);
        GeneralPath yhead = this.makeArrowhead();
        yhead.transform(AffineTransform.getScaleInstance(arrowScale, arrowScale));
        yhead.transform(AffineTransform.getTranslateInstance(x, axisScale + y + 2.0));
        g.fill(yhead);
    }

    static class BladeSet {
        private final List<Blade> blades = new ArrayList<Blade>();

        BladeSet(int bladeWidth, int bladeHeight) {
            for (int i = 0; i < 3; ++i) {
                this.blades.add(new Blade(bladeWidth, bladeHeight));
            }
        }

        void setPosition(float pos) {
            pos = Math.max(0.0f, Math.min(1.0f, pos));
            this.blades.get(0).setPosition(100.0f * pos);
            this.blades.get(1).setPosition(200.0f * pos);
            this.blades.get(2).setPosition(300.0f * pos);
        }

        float getPosition() {
            return this.blades.get(0).getPosition() / 100.0f;
        }

        void paint(Graphics2D g2) {
            for (Blade blade : this.blades) {
                blade.paint(g2);
            }
        }
    }

    private static class Blade
    extends Rectangle2D.Float {
        Blade(int width, int height) {
            super(0.0f, 0.0f, width, height);
        }

        void setPosition(float y) {
            this.y = y;
        }

        float getPosition() {
            return this.y;
        }

        private void paint(Graphics2D g2) {
            g2.setColor(BLADE_FILL_COLOR);
            g2.fill(this);
            g2.setColor(Color.BLACK);
            g2.draw(this);
        }
    }
}

