/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import hep.aida.IHistogram2D;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import plotter.Axis;
import plotter.ColorMap;
import plotter.ContinuousAxisModel;
import plotter.DataArea;
import plotter.DataOverlay;
import plotter.DefaultAxisModel;

public class Histogram2DOverlay
extends DataOverlay {
    private IHistogram2D data;
    private Axis x;
    private Axis y;
    private ContinuousAxisModel z;
    private ColorMap map;

    Histogram2DOverlay(String title, IHistogram2D data, Axis x, Axis y, ContinuousAxisModel z, ColorMap map) {
        super(title);
        this.data = data;
        this.x = x;
        this.y = y;
        this.z = z;
        this.map = map;
    }

    @Override
    public void paint(Graphics2D g) {
        DataArea da = this.getDataArea();
        DefaultAxisModel xAxisModel = (DefaultAxisModel)this.x.getModel();
        DefaultAxisModel yAxisModel = (DefaultAxisModel)this.y.getModel();
        Rectangle2D.Double rect = new Rectangle2D.Double();
        Shape clip = g.getClip();
        long start = System.currentTimeMillis();
        for (int i = 0; i < xAxisModel.getNBins(); ++i) {
            double xLow = xAxisModel.getLowerAxisCoordinateFromBin(i);
            double xHigh = xAxisModel.getUpperAxisCoordinateFromBin(i);
            rect.x = this.x.getPhysicalCoordinateFromAxisCoordinate(xLow, da);
            rect.width = this.x.getPhysicalCoordinateFromAxisCoordinate(xHigh, da) - rect.x;
            double yLow = yAxisModel.getLowerAxisCoordinateFromBin(0);
            double yHigh = yAxisModel.getUpperAxisCoordinateFromBin(yAxisModel.getNBins() - 1);
            rect.y = this.y.getPhysicalCoordinateFromAxisCoordinate(yHigh, da);
            rect.height = this.y.getPhysicalCoordinateFromAxisCoordinate(yLow, da) - rect.y;
            if (clip != null && !clip.intersects(rect)) continue;
            for (int j = 0; j < yAxisModel.getNBins(); ++j) {
                yLow = yAxisModel.getLowerAxisCoordinateFromBin(j);
                yHigh = yAxisModel.getUpperAxisCoordinateFromBin(j);
                rect.y = this.y.getPhysicalCoordinateFromAxisCoordinate(yHigh, da);
                rect.height = this.y.getPhysicalCoordinateFromAxisCoordinate(yLow, da) - rect.y;
                double zValue = this.data.binHeight(i, j);
                double zNorm = this.z.getAxisCoordinateFromModelCoordinate(zValue);
                g.setColor(this.map.getColor(zNorm, 1.0f));
                g.fill(rect);
            }
        }
        long stop = System.currentTimeMillis();
        System.out.println("Draw took " + (stop - start) + "ms");
    }
}

