package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import static java.awt.Color.GREEN;
import static java.awt.Color.RED;
import java.awt.Font;
import static java.awt.Font.BOLD;
import static java.awt.Font.ITALIC;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.RTD;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import static org.lsst.ccs.subsystem.shutter.common.ShutterSide.PLUSX;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.PtpDeviceState;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 *
 * @author tether
 */
public class GUIUtil {

    private static final Logger LOG = Logger.getLogger(GUIUtil.class.getName());
    
    private GUIUtil() {}
    
    /**
     * Provides an implementation of {@code PageActions} that just logs each method call.
     * @return A new fake dispatcher object.
     */
    public static PageActions fakeDispatcher() {
        return new PageActions() {
            @Override
            public void calibrate() {
                LOG.info("calibrate()");
            }

            @Override
            public void toggleSafetyCheck() {
                LOG.info("toggleSafetyCheck()");
            }

            @Override
            public void center() {
                LOG.info("center()");
            }

            @Override
            public void changeBrakeState(ShutterSide side, boolean brakeEngaged) {
                LOG.log(Level.INFO, "changeBrakeState({0}, {1})", new Object[]{side, brakeEngaged});
            }

            @Override
            public void closeShutter() {
                LOG.info("closeShutter()");
            }

            @Override
            public void connect() {
                LOG.info("connect()");
            }

            @Override
            public void disconnect() {
                LOG.info("disconnect()");
            }

            @Override
            public void prodMode() {
                LOG.info("prodMode()");
            }

            @Override
            public void openShutter() {
                LOG.info("openShutter()");
            }

            @Override
            public void resync() {
                LOG.info("resync()");
            }

            @Override
            public void showStateBundle(PhysicalState phys, SoftwareState soft) {
                LOG.log(Level.INFO, "showStateBundle({0}, {1})", new Object[]{phys, soft});
            }

            @Override
            public void showStatus(ShutterStatus status) {
                LOG.log(Level.INFO, "showStatus({0})", status);
            }

            @Override
            public void showWorkerIsReachable() {
                LOG.info("showWorkerIsReachable()");
            }

            @Override
            public void showWorkerIsUnreachable(String message) {
                LOG.log(Level.INFO, "showWorkerIsUnreachable({0})", message);
            }

            @Override
            public void showTrajectory(MotionDone motion) {
                LOG.log(Level.INFO, "showTrajectory({0})", motion);
            }

            @Override
            public void stopMotion() {
                LOG.info("stopMotion()");
            }

            @Override
            public void takeExposure(double exposureTime) {
                LOG.log(Level.INFO, "takeExposure({0})", exposureTime);
            }
        
        };
    }
    
    /**
     * Provides a example instance of {@code ShutterStatus} to use in GUI testing.
     * @return A {@code ShutterStatus} instance with made-up content.
     */
    public static ShutterStatus exampleShutterStatus() {
        final Map<ShutterSide, ShutterStatus.ShutterAxisStatus> axes = new EnumMap<>(ShutterSide.class);
        for (final ShutterSide side: ShutterSide.values()) {
            final ShutterStatus. ShutterAxisStatus axstat = new ShutterStatus.ShutterAxisStatus(
                side == PLUSX ? 123.0 : 631.0,     // Position
                side == PLUSX ? +1667.0 : -1234.0, // Velocity
                0.0, // Acceleration
                true, // Enabled?
                side == PLUSX,  // Brake engaged?
                false,  // At low limit?
                false,  // At high limit?
                true,   // Has been homed?
                0,      // Error code.
                side == ShutterSide.PLUSX ? 30.0 : -100.0,  // Controller IC temp, Celsius
                side == PLUSX // Safe temperature flag.
            );
            axes.put(side, axstat);
        }
        final Map<RTD, Double> temperature = new TreeMap<>();
        final Map<RTD, Boolean> tempIsSafe = new TreeMap<>();
        for (final RTD rtd: RTD.values()) {
            temperature.put(rtd, 10.0 + rtd.getIndex() * 10.0);
            tempIsSafe.put(rtd, Boolean.FALSE);
        }
        tempIsSafe.put(RTD.MINUSX_MOTOR, Boolean.TRUE);
        final ShutterStatus status = new ShutterStatus(
            0, // Motion profile code.
            true, // Shutter calibrated?
            0, // PLC state code.
            axes,
            true, // Safety checks on?
            temperature,
            tempIsSafe,
            true,  // brake power on?
            CCSTimeStamp.currentTime(),  // Message creation time.
            PtpDeviceState.SLAVE,
            0,   // Leap second count.
            false  // Leap second validity flag.
        );
        return status;
    }

    
    
    
    
    /**
     * Decides which font to use to display a value depending on whether it's in the acceptable range.
     * @param inRange is the value to be displayed in the acceptable range?
     * @return the font to use when displaying the value.
     */
    public static Font rangeFont(final boolean inRange) {
        return inRange ? IN_RANGE_FONT : OUT_OF_RANGE_FONT;
    }

    private static final Font IN_RANGE_FONT = (new JTextField()).getFont().deriveFont(BOLD);
    
    private static final Font OUT_OF_RANGE_FONT = IN_RANGE_FONT.deriveFont(ITALIC);

    public static Color rangeColor(final boolean inRange) {
        return inRange ? IN_RANGE_COLOR : OUT_OF_RANGE_COLOR;
    }
    
    private static final Color IN_RANGE_COLOR = GREEN;
    
    private static final Color OUT_OF_RANGE_COLOR = RED;

}
