package org.lsst.ccs.subsystem.shutter.gui;

import java.util.logging.Logger;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.ShutterPlugin.ShutterPage;
import org.openide.util.Exceptions;

/**
 * Sends commands out to the worker subsystem and receives the acks and nacks.
 * Not thread-safe, use only from the dispatcher thread.
 * @author tether
 */
public class Commander implements PageActions {
    private static final Logger LOG = Logger.getLogger(Commander.class.getName());

    private final ShutterPage page;
    private String workerName;

    public Commander(final ShutterPage page) {
        this.page = page;
        this.workerName = null;
    }

    ////////// Implementation of PageActions //////////

    @Override
    public void takeExposure(double exposureTime) {
        LOG.fine(() -> "takeExposure(" + exposureTime + ")");
        issueCommand("takeExposure", exposureTime);
    }

    @Override
    public void openShutter() {
        LOG.fine("openShutter()");
        issueCommand("openShutter");
    }

    @Override
    public void closeShutter() {
        LOG.fine("closeShutter()");
        issueCommand("closeShutter");
    }

    @Override
    public void changeBrakeState(final ShutterSide side, final boolean brakeEngaged) {
        LOG.fine(() -> String.format("changeBrakeState(%s, %s)", side, brakeEngaged));
        final Axis axis = side == ShutterSide.PLUSX ? Axis.getPlusXSide() : Axis.getMinusXSide();
        issueCommand("changeBrakeState", axis.getName(), brakeEngaged);
    }

    @Override
    public void calibrate() {
        LOG.fine("calibrate()");
        issueCommand("calibrate");
    }

    @Override
    public void toggleSafetyCheck() {
        LOG.fine("toggleSafetyCheck()");
        issueCommand("toggleSafetyCheck");
    }

    @Override
    public void center() {
        LOG.fine("center()");
        issueCommand("gotoCenter");
    }

    @Override
    public void prodMode() {
        LOG.fine("prodMode()");
        issueCommand("gotoProd");
    }

    @Override
    public void resync() {
        LOG.fine("resync()");
        issueCommand("resync");
    }

    @Override
    public void stopMotion() {
        LOG.fine("stopMotion()");
        issueCommand("stopAll");
    }
    
    @Override
    public void setWorkerName(final String workerName) {
        this.workerName = workerName;
    }

    ///////// Utility /////////

    private void issueCommand(final String cmd, Object... args) {
        final CommandTask task = CommandService.getService().sendRaw(workerName, cmd, args);
        try {
            // Wait for the result but don't care what it is.
            task.getResult();
        } catch (InterruptedException ex) {
            LOG.warning("Interrupted while waiting for a command result.");
        }
    }


}
