/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.taitime;

import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.time.Instant;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.utilities.taitime.LeapSecondReader;
import org.lsst.ccs.utilities.taitime.TAITime;
import org.lsst.ccs.utilities.taitime.TimeStorage;

public class CCSTimeStamp
implements Serializable,
Comparable<CCSTimeStamp> {
    private static final long serialVersionUID = 6264466048267081974L;
    private static final TAITime times;
    private static volatile LeapSecondReader reader;
    private final Instant taiInstant;
    private final Instant utcInstant;
    private static final Instant INVALID_INSTANT;
    private static final Logger LOG;

    public static CCSTimeStamp currentTime() {
        return new CCSTimeStamp();
    }

    public static CCSTimeStamp fromTAI(Instant taiTime, int dtai) {
        return new CCSTimeStamp(taiTime, dtai);
    }

    @Deprecated
    public static CCSTimeStamp currentTimeFromMillis(long milliseconds) {
        return new CCSTimeStamp(milliseconds);
    }

    private CCSTimeStamp(long milliseconds) {
        if (TAITime.isStrict()) {
            throw new RuntimeException("Cannot use in strict mode !");
        }
        if (milliseconds == 0L || milliseconds == -1L) {
            LOG.log(Level.WARNING, "Creating invalid instant version of CCSTimeStamp for milliseconds: {0}", milliseconds);
            this.utcInstant = INVALID_INSTANT;
            this.taiInstant = INVALID_INSTANT;
        } else {
            this.utcInstant = Instant.ofEpochMilli(milliseconds);
            int leapSecond = CCSTimeStamp.getReader().getNumberOfLeapSeconds(milliseconds);
            this.taiInstant = this.utcInstant.plusSeconds(leapSecond);
        }
    }

    private CCSTimeStamp(Instant taiTime, int deltaTAI) {
        this.taiInstant = taiTime;
        this.utcInstant = Instant.ofEpochSecond(taiTime.getEpochSecond() - (long)deltaTAI, taiTime.getNano());
    }

    private static LeapSecondReader createLeapSecondReader() throws RuntimeException {
        try {
            LeapSecondReader leapSecondReader;
            try {
                leapSecondReader = new LeapSecondReader();
            }
            catch (IOException x) {
                URL leapURL = BootstrapResourceUtils.getResourceURL((String)"leap-seconds.list");
                if (leapURL != null) {
                    leapSecondReader = new LeapSecondReader(leapURL);
                    LOG.warning("Unable to read default leap second file, falling back to reading local copy from bootstrap path");
                    long expires = leapSecondReader.getExpiryDate();
                    if (expires != 0L && expires < System.currentTimeMillis()) {
                        LOG.log(Level.SEVERE, "Leap second data read from {0} has expired", leapURL);
                    }
                }
                throw x;
            }
            return leapSecondReader;
        }
        catch (IOException x) {
            throw new RuntimeException("Leap second file can not be loaded", x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LeapSecondReader getReader() {
        if (reader == null) {
            TAITime tAITime = times;
            synchronized (tAITime) {
                if (reader == null) {
                    reader = CCSTimeStamp.createLeapSecondReader();
                }
            }
        }
        return reader;
    }

    private CCSTimeStamp() {
        if (times.isConfigured()) {
            TimeStorage store = times.getTime();
            this.taiInstant = Instant.ofEpochSecond(store.getTimeSecsTAI(), store.getTimeNanoTAI());
            this.utcInstant = Instant.ofEpochSecond(store.getTimeSecsUTC(), store.getTimeNanoUTC());
        } else {
            this.utcInstant = Instant.now();
            int leapSecond = reader.getNumberOfLeapSeconds(this.utcInstant.toEpochMilli());
            this.taiInstant = this.utcInstant.plusSeconds(leapSecond);
        }
    }

    public Instant getTAIInstant() {
        return this.taiInstant;
    }

    public Instant getUTCInstant() {
        return this.utcInstant;
    }

    public double getTAIDouble() {
        return (double)this.taiInstant.getEpochSecond() + (double)this.taiInstant.getNano() / 1.0E9;
    }

    public double getUTCDouble() {
        return (double)this.utcInstant.getEpochSecond() + (double)this.utcInstant.getNano() / 1.0E9;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CCSTimeStamp) {
            CCSTimeStamp ts = (CCSTimeStamp)obj;
            return this.taiInstant.equals(ts.taiInstant) && this.utcInstant.equals(ts.utcInstant);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 67 * hash + Objects.hashCode(this.taiInstant);
        hash = 67 * hash + Objects.hashCode(this.utcInstant);
        return hash;
    }

    public String toString() {
        return "CCSTimeStamp{utc=" + this.utcInstant + "}";
    }

    @Override
    public int compareTo(CCSTimeStamp o) {
        return this.taiInstant.compareTo(o.taiInstant);
    }

    static {
        INVALID_INSTANT = Instant.ofEpochMilli(0L);
        LOG = Logger.getLogger(CCSTimeStamp.class.getName());
        times = new TAITime();
        LeapSecondReader leapSecondReader = null;
        if (!TAITime.isStrict() && !times.isConfigured()) {
            leapSecondReader = CCSTimeStamp.createLeapSecondReader();
        }
        reader = leapSecondReader;
    }
}

