/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.cfg;

import com.mchange.v1.lang.BooleanUtils;
import com.mchange.v2.beans.BeansUtils;
import com.mchange.v2.c3p0.cfg.C3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.C3P0ConfigUtils;
import com.mchange.v2.c3p0.cfg.DefaultC3P0ConfigFinder;
import com.mchange.v2.c3p0.cfg.NamedScope;
import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0ImplUtils;
import com.mchange.v2.cfg.MultiPropertiesConfig;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import java.beans.IntrospectionException;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public final class C3P0Config {
    public static final String CFG_FINDER_CLASSNAME_KEY = "com.mchange.v2.c3p0.cfg.finder";
    public static final String DEFAULT_CONFIG_NAME = "default";
    public static final C3P0Config MAIN;
    static final MLogger logger;
    static final Class[] SUOAS_ARGS;
    static final Collection SKIP_BIND_PROPS;
    NamedScope defaultConfig;
    HashMap configNamesToNamedScopes;

    private static void warnOnUnknownProperties(C3P0Config cfg) {
        C3P0Config.warnOnUnknownProperties(cfg.defaultConfig);
        Iterator ii = cfg.configNamesToNamedScopes.values().iterator();
        while (ii.hasNext()) {
            C3P0Config.warnOnUnknownProperties((NamedScope)ii.next());
        }
    }

    private static void warnOnUnknownProperties(NamedScope scope) {
        C3P0Config.warnOnUnknownProperties(scope.props);
        Iterator ii = scope.userNamesToOverrides.values().iterator();
        while (ii.hasNext()) {
            C3P0Config.warnOnUnknownProperties((Map)ii.next());
        }
    }

    private static void warnOnUnknownProperties(Map propMap) {
        for (String prop : propMap.keySet()) {
            if (C3P0Defaults.isKnownProperty(prop) || !logger.isLoggable(MLevel.WARNING)) continue;
            logger.log(MLevel.WARNING, "Unknown c3p0-config property: " + prop);
        }
    }

    public static String getUnspecifiedUserProperty(String propKey, String configName) {
        String out = null;
        if (configName == null) {
            out = (String)C3P0Config.MAIN.defaultConfig.props.get(propKey);
        } else {
            NamedScope named = (NamedScope)C3P0Config.MAIN.configNamesToNamedScopes.get(configName);
            if (named != null) {
                out = (String)named.props.get(propKey);
            } else {
                logger.warning("named-config with name '" + configName + "' does not exist. Using default-config for property '" + propKey + "'.");
            }
            if (out == null) {
                out = (String)C3P0Config.MAIN.defaultConfig.props.get(propKey);
            }
        }
        return out;
    }

    public static Map getUnspecifiedUserProperties(String configName) {
        HashMap out = new HashMap();
        out.putAll(C3P0Config.MAIN.defaultConfig.props);
        if (configName != null) {
            NamedScope named = (NamedScope)C3P0Config.MAIN.configNamesToNamedScopes.get(configName);
            if (named != null) {
                out.putAll(named.props);
            } else {
                logger.warning("named-config with name '" + configName + "' does not exist. Using default-config.");
            }
        }
        return out;
    }

    public static Map getUserOverrides(String configName) {
        HashMap out = new HashMap();
        NamedScope namedConfigScope = null;
        if (configName != null) {
            namedConfigScope = (NamedScope)C3P0Config.MAIN.configNamesToNamedScopes.get(configName);
        }
        out.putAll(C3P0Config.MAIN.defaultConfig.userNamesToOverrides);
        if (namedConfigScope != null) {
            out.putAll(namedConfigScope.userNamesToOverrides);
        }
        return out.isEmpty() ? null : out;
    }

    public static String getUserOverridesAsString(String configName) throws IOException {
        Map userOverrides = C3P0Config.getUserOverrides(configName);
        if (userOverrides == null) {
            return null;
        }
        return C3P0ImplUtils.createUserOverridesAsString(userOverrides).intern();
    }

    public static void bindUserOverridesAsString(Object bean, String uoas) throws Exception {
        Method m = bean.getClass().getMethod("setUserOverridesAsString", SUOAS_ARGS);
        m.invoke(bean, uoas);
    }

    public static void bindUserOverridesToBean(Object bean, String configName) throws Exception {
        C3P0Config.bindUserOverridesAsString(bean, C3P0Config.getUserOverridesAsString(configName));
    }

    public static void bindNamedConfigToBean(Object bean, String configName, boolean shouldBindUserOverridesAsString) throws IntrospectionException {
        block4: {
            Map defaultUserProps = C3P0Config.getUnspecifiedUserProperties(configName);
            BeansUtils.overwriteAccessiblePropertiesFromMap(defaultUserProps, bean, false, SKIP_BIND_PROPS, true, MLevel.FINEST, MLevel.WARNING, false);
            try {
                if (shouldBindUserOverridesAsString) {
                    C3P0Config.bindUserOverridesToBean(bean, configName);
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.WARNING)) break block4;
                logger.log(MLevel.WARNING, "An exception occurred while trying to bind user overrides for named config '" + configName + "'. Only default user configs " + "will be used.", e);
            }
        }
    }

    public static String initializeUserOverridesAsString() {
        try {
            return C3P0Config.getUserOverridesAsString(null);
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Error initializing default user overrides. User overrides may be ignored.", e);
            }
            return null;
        }
    }

    public static String initializeStringPropertyVar(String propKey, String dflt) {
        String out = C3P0Config.getUnspecifiedUserProperty(propKey, null);
        if (out == null) {
            out = dflt;
        }
        return out;
    }

    public static int initializeIntPropertyVar(String propKey, int dflt) {
        boolean set = false;
        int out = -1;
        String outStr = C3P0Config.getUnspecifiedUserProperty(propKey, null);
        if (outStr != null) {
            try {
                out = Integer.parseInt(outStr.trim());
                set = true;
            }
            catch (NumberFormatException e) {
                logger.info("'" + outStr + "' is not a legal value for property '" + propKey + "'. Using default value: " + dflt);
            }
        }
        if (!set) {
            out = dflt;
        }
        return out;
    }

    public static boolean initializeBooleanPropertyVar(String propKey, boolean dflt) {
        boolean set = false;
        boolean out = false;
        String outStr = C3P0Config.getUnspecifiedUserProperty(propKey, null);
        if (outStr != null) {
            try {
                out = BooleanUtils.parseBoolean(outStr.trim());
                set = true;
            }
            catch (IllegalArgumentException e) {
                logger.info("'" + outStr + "' is not a legal value for property '" + propKey + "'. Using default value: " + dflt);
            }
        }
        if (!set) {
            out = dflt;
        }
        return out;
    }

    C3P0Config(NamedScope defaultConfig, HashMap configNamesToNamedScopes) {
        this.defaultConfig = defaultConfig;
        this.configNamesToNamedScopes = configNamesToNamedScopes;
    }

    static {
        C3P0Config protoMain;
        C3P0ConfigFinder cfgFinder;
        block7: {
            logger = MLog.getLogger(C3P0Config.class);
            String cname = MultiPropertiesConfig.readVmConfig().getProperty(CFG_FINDER_CLASSNAME_KEY);
            cfgFinder = null;
            try {
                if (cname != null) {
                    cfgFinder = (C3P0ConfigFinder)Class.forName(cname).newInstance();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(MLevel.WARNING)) break block7;
                logger.log(MLevel.WARNING, "Could not load specified C3P0ConfigFinder class'" + cname + "'.", e);
            }
        }
        try {
            if (cfgFinder == null) {
                Class.forName("org.w3c.dom.Node");
                Class.forName("com.mchange.v2.c3p0.cfg.C3P0ConfigXmlUtils");
                cfgFinder = new DefaultC3P0ConfigFinder();
            }
            protoMain = cfgFinder.findConfig();
        }
        catch (Exception e) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "XML configuration disabled! Verify that standard XML libs are available.", e);
            }
            HashMap flatDefaults = C3P0ConfigUtils.extractHardcodedC3P0Defaults();
            flatDefaults.putAll(C3P0ConfigUtils.extractC3P0PropertiesResources());
            protoMain = C3P0ConfigUtils.configFromFlatDefaults(flatDefaults);
        }
        MAIN = protoMain;
        C3P0Config.warnOnUnknownProperties(MAIN);
        SUOAS_ARGS = new Class[]{String.class};
        SKIP_BIND_PROPS = Arrays.asList("loginTimeout", "properties");
    }
}

