/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.util.logging.Logger;
import org.lsst.ccs.subsystem.common.ui.jas.CommandSender;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.PageActions;
import org.lsst.ccs.subsystem.shutter.gui.ShutterPlugin;

public class Commander
implements PageActions {
    private static final Logger LOG = Logger.getLogger(Commander.class.getName());
    private final ShutterPlugin.ShutterPage page;
    private String workerName;
    private CommandSender sender;

    public Commander(ShutterPlugin.ShutterPage page) {
        this.page = page;
        this.sender = null;
    }

    @Override
    public void takeExposure(double exposureTime) {
        LOG.fine(() -> "takeExposure(" + exposureTime + ")");
        this.issueCommand("takeExposure", exposureTime);
    }

    @Override
    public void openShutter() {
        LOG.fine("openShutter()");
        this.issueCommand("openShutter", new Object[0]);
    }

    @Override
    public void closeShutter() {
        LOG.fine("closeShutter()");
        this.issueCommand("closeShutter", new Object[0]);
    }

    @Override
    public void changeBrakeState(ShutterSide side, boolean brakeEngaged) {
        LOG.fine(() -> String.format("changeBrakeState(%s, %s)", side, brakeEngaged));
        Axis axis = side == ShutterSide.PLUSX ? Axis.getPlusXSide() : Axis.getMinusXSide();
        this.issueCommand("changeBrakeState", axis.getName(), brakeEngaged);
    }

    @Override
    public void calibrate() {
        LOG.fine("calibrate()");
        this.issueCommand("calibrate", new Object[0]);
    }

    @Override
    public void toggleSafetyCheck() {
        LOG.fine("toggleSafetyCheck()");
        this.issueCommand("toggleSafetyCheck", new Object[0]);
    }

    @Override
    public void center() {
        LOG.fine("center()");
        this.issueCommand("gotoCenter", new Object[0]);
    }

    @Override
    public void prodMode() {
        LOG.fine("prodMode()");
        this.issueCommand("gotoProd", new Object[0]);
    }

    @Override
    public void resync() {
        LOG.fine("resync()");
        this.issueCommand("resync", new Object[0]);
    }

    @Override
    public void stopMotion() {
        LOG.fine("stopMotion()");
        this.issueCommand("stopAll", new Object[0]);
    }

    @Override
    public void setWorkerName(String workerName) {
        this.workerName = workerName;
        this.sender = new CommandSender(workerName);
    }

    private void issueCommand(String cmd, Object ... args) {
        this.sender.sendCommand(false, null, cmd, args);
    }
}

