/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.pdf;

import hep.aida.ref.pdf.Dependent;
import hep.aida.ref.pdf.Function;
import hep.aida.ref.pdf.Parameter;
import hep.aida.ref.pdf.Variable;
import hep.aida.ref.pdf.VariableList;
import java.util.ArrayList;

public class Sum
extends Function {
    private Function[] functions;
    private Parameter[] fractions;
    private double[] fractionsValue;

    public Sum(String name, Function f1, Function f2) {
        this(name, f1, f2, null);
    }

    public Sum(String name, Function f1, Function f2, Parameter p) {
        super(name);
        this.functions = new Function[]{f1, f2};
        this.fractions = p != null ? new Parameter[]{p} : this.makeFractions(1);
        this.initializeSum(this.functions, this.fractions);
    }

    public Sum(String name, ArrayList functionsArray) {
        this(name, functionsArray, null);
    }

    public Sum(String name, ArrayList functionsArray, ArrayList fractionsArray) {
        super(name);
        this.initializeSum(functionsArray, fractionsArray);
    }

    private Parameter[] makeFractions(int size) {
        Parameter[] fractions = new Parameter[size];
        double val = 1.0 / (double)(size + 1);
        for (int i = 0; i < size; ++i) {
            fractions[i] = new Parameter("f" + i, val, 0.0, 1.0);
        }
        return fractions;
    }

    private void initializeSum(ArrayList functionsArray, ArrayList fractionsArray) {
        int i;
        this.functions = new Function[functionsArray.size()];
        for (i = 0; i < this.functions.length; ++i) {
            this.functions[i] = (Function)functionsArray.get(i);
        }
        if (fractionsArray == null) {
            this.fractions = this.makeFractions(functionsArray.size() - 1);
        } else {
            this.fractions = new Parameter[fractionsArray.size()];
            for (i = 0; i < this.fractions.length; ++i) {
                this.fractions[i] = (Parameter)fractionsArray.get(i);
            }
        }
        this.initializeSum(this.functions, this.fractions);
    }

    private void initializeSum(Function[] functions, Parameter[] fractions) {
        if (fractions.length != functions.length - 1) {
            throw new IllegalArgumentException("Invalid size for the provided objects. The number of fractions parameters should be one unit less than the size of the provided functions");
        }
        int nFunctions = functions.length;
        VariableList list = new VariableList();
        for (int i = 0; i < nFunctions; ++i) {
            Parameter fraction;
            int j;
            Function f = functions[i];
            f.normalize(true);
            for (j = 0; j < f.numberOfDependents(); ++j) {
                Dependent dep = f.getDependent(j);
                if (list.contains(dep)) continue;
                list.add(dep);
            }
            for (j = 0; j < f.numberOfParameters(); ++j) {
                Parameter par = f.getParameter(j);
                if (list.contains(par)) continue;
                list.add(par);
            }
            if (i == 0 || list.contains(fraction = fractions[i - 1])) continue;
            list.add(fraction);
        }
        this.fractionsValue = new double[fractions.length + 1];
        this.fractionsValue[0] = 1.0;
        this.addVariables(list);
    }

    @Override
    public void variableChanged(Variable var) {
        for (int i = 0; i < this.fractions.length; ++i) {
            if (var != this.fractions[i]) continue;
            this.fractionsValue[0] = this.fractionsValue[0] + this.fractionsValue[i + 1];
            this.fractionsValue[i + 1] = var.value();
            this.fractionsValue[0] = this.fractionsValue[0] - this.fractionsValue[i + 1];
            break;
        }
    }

    @Override
    public double functionValue() {
        double val = 0.0;
        for (int i = 0; i < this.functions.length; ++i) {
            val += this.functions[i].value() * this.fractionsValue[i];
        }
        return val;
    }

    @Override
    public boolean hasAnalyticalVariableGradient(Variable var) {
        for (int i = 0; i < this.functions.length; ++i) {
            if (this.functions[i].hasAnalyticalVariableGradient(var)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double evaluateAnalyticalVariableGradient(Variable var) {
        double val = 0.0;
        int index = this.indexOfFraction(var);
        for (int i = 0; i < this.functions.length; ++i) {
            val += this.functions[i].evaluateAnalyticalVariableGradient(var) * this.fractionsValue[i];
        }
        if (index != -1) {
            if (index == 0) {
                throw new IllegalArgumentException();
            }
            val += this.functions[index].value() - this.functions[0].value();
        }
        return val;
    }

    private int indexOfFraction(Variable par) {
        for (int i = 0; i < this.fractions.length; ++i) {
            if (this.fractions[i] != par) continue;
            return i + 1;
        }
        return -1;
    }

    @Override
    public boolean hasAnalyticalNormalization(Dependent dep) {
        for (int i = 0; i < this.functions.length; ++i) {
            if (this.functions[i].hasAnalyticalNormalization(dep)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double evaluateAnalyticalNormalization(Dependent dep) {
        return 1.0;
    }

    @Override
    protected void updateNormalization() {
        for (int i = 0; i < this.functions.length; ++i) {
            this.functions[i].updateNormalization();
        }
        super.updateNormalization();
    }

    public int nAddend() {
        return this.functions.length;
    }

    public Function addend(int index) {
        if (index < 0 || index > this.functions.length - 1) {
            throw new IllegalArgumentException("Illegal index value " + index);
        }
        return this.functions[index];
    }

    public double fraction(int index) {
        if (index < 0 || index > this.functions.length - 1) {
            throw new IllegalArgumentException("Illegal index value " + index);
        }
        return this.fractionsValue[index];
    }
}

