/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.ServiceLifecycle;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.alerts.InfrastructureAlert;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.framework.AgentPeriodicTask;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentMonitor;
import org.lsst.ccs.services.AgentService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.PeriodicTaskComponent;
import org.lsst.ccs.services.SchedulerNode;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public final class AgentPeriodicTaskService
implements ServiceLifecycle,
HasLifecycle,
AgentMonitor,
ClearAlertHandler,
AgentService {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.services");
    private Scheduler defaultScheduler;
    private final ConcurrentHashMap<String, PeriodicTaskComponent> tasksMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, AtomicInteger> consecutiveFailuresCountMap = new ConcurrentHashMap();
    private final Object taskLock = new Object();
    private boolean hasBeenInitialized = false;
    private ComponentLookup lookupService;
    private ComponentNode agentPeriodicTaskNode;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configurationService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    private static final String DEFAULT_SCHEDULER_NAME = "default";
    private boolean useFullPaths = false;
    private final Map<String, SchedulerNode> schedulers = new HashMap<String, SchedulerNode>();
    private final List<String> tasksBehind = new ArrayList<String>();
    private final List<String> tasksWithFaiuresWarning = new ArrayList<String>();
    private final List<String> tasksWithFaiuresAlarm = new ArrayList<String>();

    @Override
    public String getAgentServiceName() {
        return "periodicTasks";
    }

    @Override
    public void preBuild() {
        this.lookupService = this.agent.getComponentLookup();
        this.agentPeriodicTaskNode = this.lookupService.getComponentNodeForObject((Object)this);
        this.createScheduler(DEFAULT_SCHEDULER_NAME, 8);
    }

    @Override
    public void preInit() {
        this.useFullPaths = "true".equals(this.agent.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false").toLowerCase());
        this.hasBeenInitialized = true;
    }

    public Scheduler createScheduler(String name, int nThreads) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to schedule an AgentPeriodicTask. Tasks must be scheduled in the build phase of HasLifecycle.");
        }
        SchedulerNode schedulerNode = new SchedulerNode(name, nThreads);
        ComponentNode schedulerComponentNode = new ComponentNode("schedulers/" + name, (Object)schedulerNode);
        this.lookupService.addComponentNodeToLookup(this.agentPeriodicTaskNode, schedulerComponentNode);
        this.schedulers.put(name, schedulerNode);
        return schedulerNode.getScheduler();
    }

    SchedulerNode getScheduler(String name) {
        return this.schedulers.get(name);
    }

    public void scheduleAgentPeriodicTask(AgentPeriodicTask task) {
        this.scheduleAgentPeriodicTask(task, DEFAULT_SCHEDULER_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleAgentPeriodicTask(AgentPeriodicTask task, String schedulerName) {
        if (this.hasBeenInitialized) {
            throw new RuntimeException("Too late to schedule an AgentPeriodicTask. Tasks must be scheduled in the build phase of HasLifecycle.");
        }
        Object object = this.taskLock;
        synchronized (object) {
            if (this.tasksMap.containsKey(task.getTaskName())) {
                throw new RuntimeException("Task with name " + task.getTaskName() + " has already been scheduled. Tasks must be unique.");
            }
            PeriodicTaskComponent periodicTaskComponent = new PeriodicTaskComponent(task, schedulerName);
            this.tasksMap.put(task.getTaskName(), periodicTaskComponent);
            this.consecutiveFailuresCountMap.put(task.getTaskName(), new AtomicInteger(0));
            ComponentNode taskNode = new ComponentNode(task.getTaskName(), (Object)periodicTaskComponent);
            this.lookupService.addComponentNodeToLookup(this.agentPeriodicTaskNode, taskNode);
        }
    }

    public Duration getPeriodicTaskPeriod(String taskName) {
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        return Duration.ofMillis(periodicTask.getTaskPeriodMillis());
    }

    public void setPeriodicTaskPeriod(String taskName, Duration period) {
        PeriodicTaskComponent periodicTask = this.tasksMap.get(taskName);
        if (periodicTask == null) {
            throw new RuntimeException("PeriodicTask with name \"" + taskName + "\" does not exist.");
        }
        if (this.agent instanceof Subsystem && this.configurationService != null && this.stateService.getState().getState(ConfigurationState.class) != null && !this.stateService.isInState((Enum)ConfigurationState.INITIAL_SAFE)) {
            this.configurationService.change(this.useFullPaths ? this.lookupService.getComponentNodeForObject((Object)periodicTask).getPath() : taskName, "taskPeriodMillis", period.toMillis());
            return;
        }
        periodicTask.setTaskPeriodMillis(period.toMillis());
    }

    @Command(name="getAgentPeriodicTaskNames", description="Get the list of the names of the scheduled tasks", type=Command.CommandType.QUERY, category=Command.CommandCategory.SYSTEM)
    public List<String> getAgentPeriodicTaskNames() {
        return Collections.list(this.tasksMap.keys());
    }

    public List<PeriodicTaskComponent.PeriodicTaskWithScheduler> getPeriodicTasks() {
        ArrayList<PeriodicTaskComponent.PeriodicTaskWithScheduler> tasks = new ArrayList<PeriodicTaskComponent.PeriodicTaskWithScheduler>();
        for (PeriodicTaskComponent taskComponent : this.tasksMap.values()) {
            tasks.add(taskComponent.getTask());
        }
        return tasks;
    }

    private String getSchedulerState(Scheduler scheduler) {
        return "Active Threads: " + scheduler.getActiveCount() + " Pool Size: " + scheduler.getPoolSize() + " Queue Size: " + scheduler.getQueueSize();
    }

    @Override
    public String getAgentMonitorStatus(boolean useCcsBuses) {
        return this.getStatus(useCcsBuses);
    }

    @Override
    public String getAgentMonitorDescription() {
        return "Periodic Task Agent Monitor";
    }

    private synchronized String getStatus(boolean publish) {
        boolean isOk = true;
        for (PeriodicTaskComponent.PeriodicTaskWithScheduler task : this.getPeriodicTasks()) {
            if (this.isPeriodicTaskOk(task, publish)) continue;
            isOk = false;
        }
        return isOk ? "OK" : this.getStatusDescription();
    }

    private boolean isPeriodicTaskOk(PeriodicTaskComponent.PeriodicTaskWithScheduler task, boolean publish) {
        boolean isTaskOk = true;
        if (this.isPeriodicTaskBehind(task, publish)) {
            isTaskOk = false;
        }
        if (this.isPeriodicTaskFailing(task, publish)) {
            isTaskOk = false;
        }
        return isTaskOk;
    }

    private boolean isPeriodicTaskBehind(PeriodicTaskComponent.PeriodicTaskWithScheduler task, boolean publish) {
        long delay = task.getPeriodicTask().getDelay(TimeUnit.MILLISECONDS);
        long period = task.getPeriodicTask().getPeriod(TimeUnit.MILLISECONDS);
        String taskName = task.getPeriodicTask().getTaskName();
        AtomicInteger consecutiveFailureCount = this.consecutiveFailuresCountMap.get(taskName);
        if (delay <= 0L && Math.abs(delay) > period / 2L) {
            int nFailures = consecutiveFailureCount.addAndGet(1);
            if (publish && !this.tasksBehind.contains(taskName) && nFailures > 3) {
                this.tasksBehind.add(taskName);
                this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.WARNING, "The following tasks are falling behind: " + this.tasksBehind + ". " + this.getSchedulerState(task.getScheduler()));
            }
            return true;
        }
        if (delay > 0L) {
            consecutiveFailureCount.set(0);
            if (publish && this.tasksBehind.remove(taskName) && this.tasksBehind.isEmpty()) {
                this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlert(), AlertState.NOMINAL, "All tasks are keeping up. " + this.getSchedulerState(task.getScheduler()));
            }
        }
        return false;
    }

    private boolean isPeriodicTaskFailing(PeriodicTaskComponent.PeriodicTaskWithScheduler task, boolean publish) {
        int taskFailures = task.getPeriodicTask().getFailures();
        String taskName = task.getPeriodicTask().getTaskName();
        if (taskFailures > 0) {
            int taskMaxFailures = task.getPeriodicTask().getMaxFailures();
            if (taskFailures > taskMaxFailures / 2 && taskFailures < taskMaxFailures) {
                if (publish && !this.tasksWithFaiuresWarning.contains(taskName)) {
                    this.tasksWithFaiuresWarning.add(taskName);
                    this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.WARNING, "Task " + taskName + " has experienced " + taskFailures + " exceptions. The maximum allowed exceptions is " + taskMaxFailures + " (" + this.tasksWithFaiuresWarning + "). " + this.getSchedulerState(task.getScheduler()));
                }
            } else if (taskFailures >= taskMaxFailures) {
                if (publish && !this.tasksWithFaiuresAlarm.contains(taskName)) {
                    this.tasksWithFaiuresAlarm.add(taskName);
                    this.alertService.raiseAlert(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlert(), AlertState.ALARM, "Task " + taskName + " has experenced the maximum allowed number of exceptions: " + taskFailures + " (max:" + taskMaxFailures + "). It will stop executing. (" + this.tasksWithFaiuresAlarm + "). " + this.getSchedulerState(task.getScheduler()));
                }
                return true;
            }
        }
        return false;
    }

    private String getStatusDescription() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> tasksFallingBehind = new ArrayList<String>();
        ArrayList<String> tasksWithFailure = new ArrayList<String>();
        for (PeriodicTaskComponent.PeriodicTaskWithScheduler task : this.getPeriodicTasks()) {
            if (this.isPeriodicTaskBehind(task, false)) {
                tasksFallingBehind.add(task.getPeriodicTask().getTaskName());
            }
            if (!this.isPeriodicTaskFailing(task, false)) continue;
            tasksWithFailure.add(task.getPeriodicTask().getTaskName());
        }
        if (!tasksFallingBehind.isEmpty()) {
            sb.append("Tasks falling behind: ");
            for (String taskName : tasksFallingBehind) {
                sb.append(taskName).append(" ");
            }
        }
        if (!tasksWithFailure.isEmpty()) {
            sb.append("Tasks with failures: ");
            for (String taskName : tasksWithFailure) {
                sb.append(taskName).append(" ");
            }
        }
        return sb.toString();
    }

    @Override
    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState state) {
        String alertId = alert.getAlertId();
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_FAILURE.getAlertId())) {
            for (PeriodicTaskComponent.PeriodicTaskWithScheduler task : this.getPeriodicTasks()) {
                if (!this.isPeriodicTaskFailing(task, false)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        if (alertId.equals(InfrastructureAlert.PERIODIC_TASK_BEHIND.getAlertId())) {
            for (PeriodicTaskComponent.PeriodicTaskWithScheduler task : this.getPeriodicTasks()) {
                if (!this.isPeriodicTaskBehind(task, false)) continue;
                return ClearAlertHandler.ClearAlertCode.DONT_CLEAR_ALERT;
            }
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }
}

