/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystem.shutter.common.EncoderSample;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import util.ListenerList;

public class EncoderPlotData
implements DiscretePlotData,
MutablePlotData {
    public static final int TIME = 0;
    public static final int POSITION = 1;
    public static final int ERROR = 2;
    private final List<EncoderDatum> data = new ArrayList<EncoderDatum>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Position"};
    private static double DEFAULT_ERROR = 0.02;

    public void reset() {
        this.data.clear();
        this.firePlotDataChanged();
    }

    public void addData(List<EncoderSample> pos, CCSTimeStamp t0) {
        for (EncoderSample p : pos) {
            double t = (double)p.timeDiff(t0).toMillis() * 0.001;
            this.data.add(new EncoderDatum(t, p.getPosition(), DEFAULT_ERROR));
        }
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.data.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        EncoderDatum mp = this.data.get(index);
        switch (dim) {
            case 0: {
                value.set(mp.getTime());
                break;
            }
            case 1: {
                value.set(mp.getPosition());
                break;
            }
            case 2: {
                value.set(mp.getError());
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Motor Readout";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.data;
    }

    private static class EncoderDatum {
        private final double time;
        private final double position;
        private final double error;

        public EncoderDatum(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getError() {
            return this.error;
        }
    }
}

