/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.jas.plugin.web;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

class ClasspathStreamHandler
extends URLStreamHandler {
    private ClassLoader loader;

    ClasspathStreamHandler() {
        this(null);
    }

    ClasspathStreamHandler(ClassLoader loader) {
        this.loader = loader == null ? this.getClass().getClassLoader() : loader;
    }

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        return new ClasspathURLConnection(u, this.loader);
    }

    static class ClasspathURLConnection
    extends URLConnection {
        private ClassLoader loader;
        private URLConnection conn;

        ClasspathURLConnection(URL u, ClassLoader loader) {
            super(u);
            this.loader = loader;
        }

        @Override
        public void connect() throws IOException {
            URL resourceURL;
            String path = this.url.getPath();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((resourceURL = this.loader.getResource(path)) == null) {
                throw new IOException("Can not open " + this.url);
            }
            this.conn = resourceURL.openConnection();
            if (this.conn == null) {
                throw new IOException("Can not open " + this.url);
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.conn == null) {
                this.connect();
            }
            return this.conn.getInputStream();
        }

        @Override
        public Object getContent() throws IOException {
            if (this.conn == null) {
                this.connect();
            }
            return this.conn.getContent();
        }

        @Override
        public String getContentType() {
            try {
                if (this.conn == null) {
                    this.connect();
                }
                return this.conn.getContentType();
            }
            catch (IOException x) {
                return null;
            }
        }

        @Override
        public long getDate() {
            try {
                if (this.conn == null) {
                    this.connect();
                }
                return this.conn.getDate();
            }
            catch (IOException x) {
                return 0L;
            }
        }

        @Override
        public int getContentLength() {
            try {
                if (this.conn == null) {
                    this.connect();
                }
                return this.conn.getContentLength();
            }
            catch (IOException x) {
                return -1;
            }
        }

        @Override
        public long getLastModified() {
            try {
                if (this.conn == null) {
                    this.connect();
                }
                return this.conn.getLastModified();
            }
            catch (IOException x) {
                return 0L;
            }
        }

        @Override
        public String getContentEncoding() {
            try {
                if (this.conn == null) {
                    this.connect();
                }
                return this.conn.getContentEncoding();
            }
            catch (IOException x) {
                return null;
            }
        }
    }
}

