/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.RTD;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.gui.GUIUtil;
import org.lsst.ccs.subsystem.shutter.gui.PageActions;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class GeneralStatusPanel
extends JPanel
implements PageActions {
    public GeneralStatusPanel() {
        this.setLayout(new GridLayout(1 + Row.values().length, 2));
        Function<String, JLabel> newHeading = text -> {
            JLabel label = new JLabel((String)text);
            label.setFont(label.getFont().deriveFont(3));
            label.setHorizontalAlignment(0);
            return label;
        };
        this.add(newHeading.apply("Parameter"));
        this.add(newHeading.apply("Value"));
        for (Row r : Row.values()) {
            this.add(r.rowName);
            this.add(r.value);
        }
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), "General status");
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        border.setTitleJustification(2);
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    @Override
    public void showStatus(ShutterStatus status) {
        Row.Calibrated.setValue(status.isCalibrated() ? "YES" : "NO");
        Row.SafetyChecks.setValue(status.isSafetyOn() ? "ON" : "OFF");
        Row.CtrlTemp.setValue(status.getTemperature().get(RTD.CONTROL_BOX));
        JTextField value = Row.CtrlTemp.value;
        value.setFont(GUIUtil.rangeFont((Boolean)status.getTempIsSafe().get(RTD.CONTROL_BOX)));
        value.setForeground(GUIUtil.rangeColor((Boolean)status.getTempIsSafe().get(RTD.CONTROL_BOX)));
    }

    @Override
    public void showWorkerIsUnreachable(String message) {
        for (Row r : Row.values()) {
            r.clearValue();
        }
        Row.SubsysVisible.setValue("NO");
    }

    @Override
    public void showStateBundle(PhysicalState phys, SoftwareState soft) {
        Row.PhysState.setValue(phys);
        Row.SoftState.setValue(soft.getDescription());
    }

    @Override
    public void showWorkerIsReachable() {
        Row.SubsysVisible.setValue("YES");
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            GeneralStatusPanel panel = new GeneralStatusPanel();
            frame.getContentPane().add((Component)panel, "Center");
            panel.showStatus(GUIUtil.exampleShutterStatus());
            panel.showStateBundle(PhysicalState.CLOSED, SoftwareState.CLOSED);
            panel.showWorkerIsReachable();
            frame.pack();
            frame.setVisible(true);
        });
    }

    private static enum Row {
        SubsysVisible("Subsystem visible?", "%s"),
        PhysState("Physical state", "%s"),
        SoftState("Subsystem state", "%s"),
        Calibrated("Calibrated?", "%s"),
        SafetyChecks("Safety checks", "%s"),
        CtrlTemp("Control box temp", "%7.1f \u2103");

        public final JLabel rowName;
        public final String format;
        public final JTextField value;

        private Row(String rowName, String format) {
            this.rowName = new JLabel(rowName);
            this.format = format;
            this.value = new JTextField();
            this.value.setEditable(false);
        }

        public void setValue(Object v) {
            this.value.setText(String.format(this.format, v));
        }

        public void clearValue() {
            this.value.setText("");
        }
    }
}

