/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.PluginActions;
import org.lsst.ccs.subsystem.shutter.gui.ShutterPlugin;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.logging.Logger;

public class Dispatcher
implements PluginActions {
    private static final Logger LOG = Logger.getLogger((String)Dispatcher.class.getName());
    private final ShutterPlugin plugin;
    private final List<PluginActions> receivers;
    private final BlockingQueue<Runnable> actions;

    public Dispatcher(ShutterPlugin plugin, PluginActions ... receivers) {
        this.plugin = plugin;
        this.receivers = Collections.unmodifiableList(Arrays.asList(receivers));
        this.actions = new LinkedBlockingQueue<Runnable>();
    }

    void start() {
        this.plugin.getScheduler().setLogger(LOG);
        this.plugin.getScheduler().setDefaultLogLevel(Level.SEVERE);
        LOG.fine((Object)"Starting the dispatcher task.");
        this.plugin.getScheduler().scheduleWithFixedDelay(() -> {
            try {
                while (true) {
                    this.actions.take().run();
                }
            }
            catch (InterruptedException exc) {
                LOG.fine((Object)"The dispatcher task is stopped.");
                return;
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void takeExposure(double exposureTime) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.takeExposure(exposureTime);
            }
        });
    }

    @Override
    public void showTrajectory(MotionDone motion) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showTrajectory(motion);
            }
        });
    }

    @Override
    public void showWorkerIsUnreachable(String message) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showWorkerIsUnreachable(message);
            }
        });
    }

    @Override
    public void showWorkerIsReachable() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showWorkerIsReachable();
            }
        });
    }

    @Override
    public void showStatus(ShutterStatus status) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showStatus(status);
            }
        });
    }

    @Override
    public void showPhysicalState(PhysicalState phys) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showPhysicalState(phys);
            }
        });
    }

    @Override
    public void showCommandFailure(String message) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showCommandFailure(message);
            }
        });
    }

    @Override
    public void showCommandSuccess() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showCommandSuccess();
            }
        });
    }

    @Override
    public void openShutter() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.openShutter();
            }
        });
    }

    @Override
    public void disconnect() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.disconnect();
            }
        });
    }

    @Override
    public void connect() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.connect();
            }
        });
    }

    @Override
    public void closeShutter() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.closeShutter();
            }
        });
    }

    @Override
    public void changeBrakeState(ShutterSide side, boolean brakeOn) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.changeBrakeState(side, brakeOn);
            }
        });
    }

    @Override
    public void stopMotion() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.stopMotion();
            }
        });
    }

    @Override
    public void resync() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.resync();
            }
        });
    }

    @Override
    public void goToProd() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.goToProd();
            }
        });
    }

    @Override
    public void center() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.center();
            }
        });
    }

    @Override
    public void calibrate() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.calibrate();
            }
        });
    }
}

