/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import data.DiscretePlotData;
import data.MetaData;
import data.MutablePlotData;
import data.PlotDataListener;
import data.SuggestedRange;
import java.util.ArrayList;
import java.util.List;
import org.freehep.util.Value;
import org.lsst.ccs.subsystem.shutter.common.HallTransition;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import util.ListenerList;

public class HallPlotData
implements DiscretePlotData,
MutablePlotData {
    public static final int TIME = 0;
    public static final int POSITION = 1;
    public static final int ERROR = 2;
    private final List<HallDatum> data = new ArrayList<HallDatum>();
    private final ListenerList<PlotDataListener> listeners = new ListenerList();
    private final String[] names = new String[]{"Time", "Position"};
    private static double DEFAULT_ERROR = 0.02;

    public void reset() {
        this.data.clear();
        this.firePlotDataChanged();
    }

    public void addData(List<HallTransition> trans, CCSTimeStamp t0) {
        for (HallTransition h : trans) {
            double t = (double)h.timeDiff(t0).toMillis() * 0.001;
            HallDatum d = new HallDatum(t, h.getPosition(), DEFAULT_ERROR);
            this.data.add(d);
        }
        this.firePlotDataChanged();
    }

    public int getNPoints() {
        return this.data.size();
    }

    public int getNDimensions() {
        return this.names.length;
    }

    public String names(int index) {
        return this.names[index];
    }

    public Class types(int index) {
        return Double.TYPE;
    }

    public void getValue(Value value, int dim, int index) {
        HallDatum transition = this.data.get(index);
        switch (dim) {
            case 0: {
                value.set(transition.getTime());
                break;
            }
            case 1: {
                value.set(transition.getPosition());
                break;
            }
            case 2: {
                value.set(transition.getError());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("dim out of bounds.");
            }
        }
    }

    public MetaData getMetaData() {
        return null;
    }

    public String getTitle() {
        return "Hall transitions";
    }

    public SuggestedRange getSuggestedRange() {
        return null;
    }

    public void addPlotDataListener(PlotDataListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removePlotDataListener(PlotDataListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    private void firePlotDataChanged() {
        if (!this.listeners.isEmpty()) {
            for (PlotDataListener l : this.listeners.getListeners()) {
                l.dataChanged();
            }
        }
    }

    public Object lock() {
        return this.data;
    }

    private static class HallDatum {
        private final double time;
        private final double position;
        private final double error;

        public HallDatum(double time, double position, double error) {
            this.time = time;
            this.position = position;
            this.error = error;
        }

        public double getTime() {
            return this.time;
        }

        public double getPosition() {
            return this.position;
        }

        public double getError() {
            return this.error;
        }
    }
}

