/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.BladesDisplay;
import org.lsst.ccs.subsystem.shutter.gui.EncoderPlotData;
import org.lsst.ccs.subsystem.shutter.gui.HallPlotData;
import org.lsst.ccs.subsystem.shutter.gui.PluginActions;
import org.lsst.ccs.subsystem.shutter.gui.PredictionPlotData;
import org.lsst.ccs.subsystem.shutter.gui.TrajectoryDisplay;
import org.lsst.ccs.subsystem.shutter.sim.CubicSCurve;
import org.lsst.ccs.subsystem.shutter.sim.MotionProfile;
import org.lsst.ccs.subsystem.shutter.sim.PredictedTrajectory;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class DisplayPanel
extends JPanel
implements PluginActions {
    private static final Logger LOG = Logger.getLogger(DisplayPanel.class.getName());
    private final BladesDisplay assembly;
    private final TrajectoryDisplay plotPanel;
    private final Map<ShutterSide, PredictionPlotData> prediction = new EnumMap<ShutterSide, PredictionPlotData>(ShutterSide.class);
    private final Map<ShutterSide, HallPlotData> hallData = new EnumMap<ShutterSide, HallPlotData>(ShutterSide.class);
    private final Map<ShutterSide, EncoderPlotData> encoderData = new EnumMap<ShutterSide, EncoderPlotData>(ShutterSide.class);
    private static final Duration PREDICTION_SAMPLING_INTERVAL = Duration.ofMillis(50L);

    public DisplayPanel() {
        super(new BorderLayout());
        this.assembly = new BladesDisplay();
        this.prediction.put(ShutterSide.PLUSX, new PredictionPlotData());
        this.prediction.put(ShutterSide.MINUSX, new PredictionPlotData());
        this.hallData.put(ShutterSide.PLUSX, new HallPlotData());
        this.hallData.put(ShutterSide.MINUSX, new HallPlotData());
        this.encoderData.put(ShutterSide.PLUSX, new EncoderPlotData());
        this.encoderData.put(ShutterSide.MINUSX, new EncoderPlotData());
        this.plotPanel = new TrajectoryDisplay(this.prediction, this.hallData, this.encoderData);
        JSplitPane split = new JSplitPane(1);
        split.add(this.plotPanel);
        split.add(this.assembly);
        this.add((Component)split, "Center");
    }

    public void setBladeSetPositions(double plus, double minus) {
        this.assembly.getShutter(ShutterSide.PLUSX).setPosition((float)plus);
        this.assembly.getShutter(ShutterSide.MINUSX).setPosition((float)minus);
        this.assembly.setVisible(true);
        this.assembly.repaint();
    }

    public void hideAssembly() {
        this.assembly.setVisible(false);
        this.assembly.repaint();
    }

    Map<ShutterSide, PredictionPlotData> getHistories() {
        return this.prediction;
    }

    public void showPredictedTrajectory(MotionDone motion) {
        double moveTime = (double)motion.targetDuration().toNanos() * 1.0E-9;
        double startPos = motion.side().getNormalizedPosition(motion.startPosition());
        double targetPos = motion.side().getNormalizedPosition(motion.targetPosition());
        PredictedTrajectory motor = new PredictedTrajectory(startPos, motion.startTime(), PREDICTION_SAMPLING_INTERVAL, 1 + (int)Math.floor(1.0E9 * moveTime / (double)PREDICTION_SAMPLING_INTERVAL.toNanos()), (MotionProfile)new CubicSCurve(targetPos - startPos, moveTime));
        PredictionPlotData plotData = this.prediction.get(motion.side());
        plotData.reset();
        this.prediction.get(motion.side().opposite()).reset();
        plotData.addData(motor.getPositions(), motion.startTime());
        int n = plotData.getNPoints();
        this.plotPanel.setTimePeriod((float)moveTime);
    }

    void showActualTrajectory(MotionDone motion) {
        this.showEncoderSamples(motion);
        this.showActualHallTransitions(motion);
    }

    private void showEncoderSamples(MotionDone motion) {
        BladesDisplay.BladeSet blades = this.assembly.getShutter(motion.side());
        float newPos = (float)motion.side().getNormalizedPosition(motion.endPosition());
        blades.setPosition(newPos);
        this.assembly.repaint();
        this.encoderData.get(motion.side()).reset();
        this.encoderData.get(motion.side().opposite()).reset();
        this.encoderData.get(motion.side()).addData(motion.encoderSamples(), motion.startTime());
    }

    void showActualHallTransitions(MotionDone motion) {
        this.hallData.get(motion.side()).reset();
        this.hallData.get(motion.side().opposite()).reset();
        this.hallData.get(motion.side()).addData(motion.hallTransitions(), motion.startTime());
    }

    @Override
    public void showTrajectory(MotionDone motion) {
        LOG.fine("showTrajectory()");
        SwingUtilities.invokeLater(() -> this.showPredictedTrajectory(motion));
        SwingUtilities.invokeLater(() -> this.showActualTrajectory(motion));
    }

    @Override
    public void showStatus(ShutterStatus status) {
        LOG.fine("showStatus()");
        for (ShutterSide side : ShutterSide.values()) {
            ShutterStatus.AxisStatus axis = status.getAxisStatus(side);
            SwingUtilities.invokeLater(() -> this.assembly.getShutter(side).setPosition((float)side.getNormalizedPosition(axis.getActPos())));
        }
        SwingUtilities.invokeLater(() -> this.assembly.repaint());
    }
}

