/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;

public final class BladesDisplay
extends JComponent {
    private static final int DISPLAY_WIDTH = 500;
    private static final int DISPLAY_HEIGHT = 400;
    private static final int BLADE_WIDTH = 100;
    private static final int BLADE_HEIGHT = 400;
    private static final int APERTURE_DIAMETER = 300;
    private static final int APERTURE_WIDTH_INSET = 100;
    private static final int APERTURE_HEIGHT_INSET = 50;
    private static final Color BLADE_FILL_COLOR = new Color(0.5f, 0.5f, 0.5f, 0.5f);
    private final Map<ShutterSide, BladeSet> shutters = new EnumMap<ShutterSide, BladeSet>(ShutterSide.class);

    public BladesDisplay() {
        Dimension dimension = new Dimension(500, 400);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.shutters.put(ShutterSide.PLUSX, new BladeSet(100, 400));
        this.shutters.put(ShutterSide.MINUSX, new BladeSet(100, 400));
        this.shutters.get(ShutterSide.PLUSX).setPosition(0.0f);
        this.shutters.get(ShutterSide.MINUSX).setPosition(1.0f);
    }

    BladeSet getShutter(ShutterSide side) {
        return this.shutters.get(side);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.addRenderingHints(hints);
        Arc2D.Float circle = new Arc2D.Float(100.0f, 50.0f, 300.0f, 300.0f, 0.0f, 360.0f, 1);
        g2.draw(circle);
        this.shutters.get(ShutterSide.MINUSX).paint(g2);
        AffineTransform savedTransform = g2.getTransform();
        try {
            g2.translate(500, 0);
            g2.scale(-1.0, 1.0);
            this.shutters.get(ShutterSide.PLUSX).paint(g2);
        }
        finally {
            g2.setTransform(savedTransform);
        }
    }

    private static class Blade
    extends Rectangle2D.Float {
        Blade(int width, int height) {
            super(0.0f, 0.0f, width, height);
        }

        void setPosition(float x) {
            this.x = x;
        }

        float getPosition() {
            return this.x;
        }

        private void paint(Graphics2D g2) {
            g2.setColor(BLADE_FILL_COLOR);
            g2.fill(this);
            g2.setColor(Color.BLACK);
            g2.draw(this);
        }
    }

    static class BladeSet {
        private final List<Blade> blades = new ArrayList<Blade>();

        BladeSet(int bladeWidth, int bladeHeight) {
            for (int i = 0; i < 3; ++i) {
                this.blades.add(new Blade(bladeWidth, bladeHeight));
            }
        }

        void setPosition(float pos) {
            pos = Math.max(0.0f, Math.min(1.0f, pos));
            this.blades.get(0).setPosition(100.0f * pos);
            this.blades.get(1).setPosition(200.0f * pos);
            this.blades.get(2).setPosition(300.0f * pos);
        }

        float getPosition() {
            return this.blades.get(0).getPosition() / 100.0f;
        }

        void paint(Graphics2D g2) {
            for (Blade blade : this.blades) {
                blade.paint(g2);
            }
        }
    }
}

