/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.lsst.ccs.subsystem.shutter.common.Constants;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.GUIUtil;
import org.lsst.ccs.subsystem.shutter.gui.PageActions;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class BladeSetStatusPanel
extends JPanel
implements PageActions {
    private static final Font PLAIN_TEXTFIELD_FONT = new JTextField().getFont();
    private static final Font ITALIC_TEXTFIELD_FONT = PLAIN_TEXTFIELD_FONT.deriveFont(2);

    public BladeSetStatusPanel() {
        this.setLayout(new GridLayout(1 + Row.values().length, 3));
        Function<String, JLabel> newHeading = text -> {
            JLabel label = new JLabel((String)text);
            label.setFont(label.getFont().deriveFont(3));
            label.setHorizontalAlignment(0);
            return label;
        };
        this.add(newHeading.apply("Parameter"));
        this.add(newHeading.apply("+X side"));
        this.add(newHeading.apply("-X side"));
        for (Row r : Row.values()) {
            this.add(r.rowName);
            this.add(r.values.get(ShutterSide.PLUSX));
            this.add(r.values.get(ShutterSide.MINUSX));
        }
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black, 1), "Blade set status");
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        border.setTitleJustification(2);
        this.setBorder(BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
    }

    @Override
    public void showStatus(ShutterStatus status) {
        ShutterSide[] shutterSideArray = ShutterSide.values();
        int n = shutterSideArray.length;
        for (int i = 0; i < n; ++i) {
            ShutterSide side;
            ShutterStatus.AxisStatus axstatus = status.getAxisStatus(side = shutterSideArray[i]);
            Row.BrakeStatus.setValue(side, axstatus.isBrakeEngaged() ? "ENGAGED" : "RELEASED");
            double pos = axstatus.getActPos();
            double vel = axstatus.getActVel();
            double home = (Double)Constants.BLADE_SET_HOME.get(side);
            double percent = 100.0 * Math.abs(pos - home) / 750.0;
            Row.Position.setValue(side, pos);
            Row.Extension.setValue(side, percent);
            Row.Velocity.setValue(side, vel);
            Row.ChipTemp.setValue(side, axstatus.getMotorTemp());
            JTextField value = Row.ChipTemp.values.get(side);
            if (axstatus.hasSafeTemp()) {
                value.setForeground(Color.GREEN);
                value.setFont(PLAIN_TEXTFIELD_FONT);
                continue;
            }
            value.setForeground(Color.RED);
            value.setFont(ITALIC_TEXTFIELD_FONT);
        }
    }

    @Override
    public void showWorkerIsUnreachable(String message) {
        for (Row r : Row.values()) {
            r.clearValues();
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> {
            JFrame frame = new JFrame();
            BladeSetStatusPanel panel = new BladeSetStatusPanel();
            frame.getContentPane().add((Component)panel, "Center");
            panel.showStatus(GUIUtil.exampleShutterStatus());
            frame.pack();
            frame.setVisible(true);
        });
    }

    private static enum Row {
        Position("Position", "% 5.1f mm"),
        Extension("How far extended", "% 5.1f%%"),
        Velocity("Velocity", "% 7.1f mm/s"),
        ChipTemp("IC chip temperature", "% 5.1f \u2103"),
        BrakeStatus("Axis brake", "%s");

        public final JLabel rowName;
        public final String format;
        public final Map<ShutterSide, JTextField> values;

        private Row(String rowName, String format) {
            this.rowName = new JLabel(rowName);
            this.format = format;
            this.values = new EnumMap<ShutterSide, JTextField>(ShutterSide.class);
            this.values.put(ShutterSide.PLUSX, new JTextField());
            this.values.put(ShutterSide.MINUSX, new JTextField());
            this.values.get(ShutterSide.PLUSX).setEditable(false);
            this.values.get(ShutterSide.MINUSX).setEditable(false);
        }

        public void setValue(ShutterSide side, Object v) {
            this.values.get(side).setText(String.format(this.format, v));
        }

        public void clearValues() {
            this.values.get(ShutterSide.PLUSX).setText("");
            this.values.get(ShutterSide.MINUSX).setText("");
        }
    }
}

