package org.lsst.ccs.subsystem.shutter.gui;


import javax.swing.Box;
import javax.swing.BoxLayout;



/**
 * A panel that contains the entire GUI with the trajectory and blades displays at the top
 * and the control panel at the bottom.
 * @author tether
 */
public class RootPanel extends Box {

    public static RootPanel create(
        final DisplayPanel displays,
        final GeneralStatusPanel generalTable,
        final BladeSetStatusPanel bladeTable,
        final CommandPanel commandButtons)
    {
        final RootPanel root = new RootPanel();
        root.add(displays);
        
        final Box row1 = new Box(BoxLayout.LINE_AXIS);
        row1.add(Box.createHorizontalGlue());
        row1.add(generalTable);
        row1.add(bladeTable);
        row1.add(commandButtons);
        row1.add(Box.createHorizontalGlue());
        root.add(row1);
        return root;
    }

    public RootPanel() {
        super(BoxLayout.PAGE_AXIS);
    }
}