/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.gui.PluginActions;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.scheduler.Scheduler;

public class Dispatcher
implements PluginActions {
    private static final Logger LOG = Logger.getLogger((String)Dispatcher.class.getName());
    private final List<PluginActions> receivers = new CopyOnWriteArrayList<PluginActions>();
    private final BlockingQueue<Runnable> actions = new LinkedBlockingQueue<Runnable>();

    public void addReceivers(PluginActions ... recv) {
        this.receivers.addAll(Arrays.asList(recv));
    }

    void start(Scheduler sched) {
        sched.setLogger(LOG);
        sched.setDefaultLogLevel(Level.SEVERE);
        LOG.fine((Object)"Starting the dispatcher task.");
        sched.scheduleWithFixedDelay(() -> {
            try {
                while (true) {
                    Runnable action = this.actions.take();
                    SwingUtilities.invokeLater(() -> action.run());
                }
            }
            catch (InterruptedException exc) {
                LOG.fine((Object)"The dispatcher task is stopped.");
                return;
            }
        }, 0L, 10L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void takeExposure(double exposureTime) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.takeExposure(exposureTime);
            }
        });
    }

    @Override
    public void showTrajectory(MotionDone motion) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showTrajectory(motion);
            }
        });
    }

    @Override
    public void showWorkerIsUnreachable(String message) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showWorkerIsUnreachable(message);
            }
        });
    }

    @Override
    public void showWorkerIsReachable() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showWorkerIsReachable();
            }
        });
    }

    @Override
    public void showStatus(ShutterStatus status) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showStatus(status);
            }
        });
    }

    @Override
    public void showStateBundle(PhysicalState phys, SoftwareState soft) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showStateBundle(phys, soft);
            }
        });
    }

    @Override
    public void showCommandFailure(String message) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showCommandFailure(message);
            }
        });
    }

    @Override
    public void showCommandSuccess() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.showCommandSuccess();
            }
        });
    }

    @Override
    public void openShutter() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.openShutter();
            }
        });
    }

    @Override
    public void disconnect() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.disconnect();
            }
        });
    }

    @Override
    public void connect() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.connect();
            }
        });
    }

    @Override
    public void closeShutter() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.closeShutter();
            }
        });
    }

    @Override
    public void changeBrakeState(ShutterSide side, boolean brakeEngaged) {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.changeBrakeState(side, brakeEngaged);
            }
        });
    }

    @Override
    public void stopMotion() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.stopMotion();
            }
        });
    }

    @Override
    public void resync() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.resync();
            }
        });
    }

    @Override
    public void prodMode() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.prodMode();
            }
        });
    }

    @Override
    public void center() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.center();
            }
        });
    }

    @Override
    public void calibrate() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.calibrate();
            }
        });
    }

    @Override
    public void toggleSafetyCheck() {
        this.actions.add(() -> {
            for (PluginActions rcv : this.receivers) {
                rcv.toggleSafetyCheck();
            }
        });
    }
}

