package org.lsst.ccs.subsystem.shutter.gui;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import static org.lsst.ccs.subsystem.shutter.common.ShutterSide.PLUSX;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

/**
 *
 * @author tether
 */
public class GUIUtil {

    private static final Logger LOG = Logger.getLogger(GUIUtil.class.getName());
    
    private GUIUtil() {}
    
    /**
     * Provides an implementation of {@code PluginActions} that just logs each method call.
     * @return A new fake dispatcher object.
     */
    public static PluginActions fakeDispatcher() {
        return new PluginActions() {
            @Override
            public void calibrate() {
                LOG.info("calibrate()");
            }

            @Override
            public void toggleSafetyCheck() {
                LOG.info("toggleSafetyCheck()");
            }

            @Override
            public void center() {
                LOG.info("center()");
            }

            @Override
            public void changeBrakeState(ShutterSide side, boolean brakeEngaged) {
                LOG.log(Level.INFO, "changeBrakeState({0}, {1})", new Object[]{side, brakeEngaged});
            }

            @Override
            public void closeShutter() {
                LOG.info("closeShutter()");
            }

            @Override
            public void connect() {
                LOG.info("connect()");
            }

            @Override
            public void disconnect() {
                LOG.info("disconnect()");
            }

            @Override
            public void prodMode() {
                LOG.info("prodMode()");
            }

            @Override
            public void openShutter() {
                LOG.info("openShutter()");
            }

            @Override
            public void resync() {
                LOG.info("resync()");
            }

            @Override
            public void showCommandSuccess() {
                LOG.info("showCommandSuccess()");
            }

            @Override
            public void showCommandFailure(String message) {
                LOG.log(Level.INFO, "showCommandFailure({0})", message);
            }

            @Override
            public void showStateBundle(PhysicalState phys, SoftwareState soft) {
                LOG.log(Level.INFO, "showStateBundle({0}, {1})", new Object[]{phys, soft});
            }

            @Override
            public void showStatus(ShutterStatus status) {
                LOG.log(Level.INFO, "showStatus({0})", status);
            }

            @Override
            public void showWorkerIsReachable() {
                LOG.info("showWorkerIsReachable()");
            }

            @Override
            public void showWorkerIsUnreachable(String message) {
                LOG.log(Level.INFO, "showWorkerIsUnreachable({0})", message);
            }

            @Override
            public void showTrajectory(MotionDone motion) {
                LOG.log(Level.INFO, "showTrajectory({0})", motion);
            }

            @Override
            public void stopMotion() {
                LOG.info("stopMotion()");
            }

            @Override
            public void takeExposure(double exposureTime) {
                LOG.log(Level.INFO, "takeExposure({0})", exposureTime);
            }
        
        };
    }
    
    /**
     * Provides a example instance of {@code ShutterStatus} to use in GUI testing.
     * @return A {@code ShutterStatus} instance with made-up content.
     */
    public static ShutterStatus exampleShutterStatus() {
        final Map<ShutterSide, ShutterStatus.AxisStatus> axes = new EnumMap<>(ShutterSide.class);
        for (final ShutterSide side: ShutterSide.values()) {
            final ShutterStatus.AxisStatus axstat = new ShutterStatus.AxisStatus(
                side == PLUSX ? 123.0 : 631.0,     // Position
                side == PLUSX ? +1667.0 : -1234.0, // Velocity
                0.0, // Acceleration
                true, // Enabled?
                side == PLUSX,  // Brake engaged?
                false,  // At low limit?
                false,  // At high limit?
                true,   // Has been homed?
                0,      // Error code.
                side == ShutterSide.PLUSX ? 30.0 : -100.0,  // Controller IC temp, Celsius
                side == PLUSX // Safe temperature flag.
            );
            axes.put(side, axstat);
        }
        final ShutterStatus status = new ShutterStatus(
            0, // Motion profile code.
            true, // Shutter calibrated?
            0, // PLC state code.
            axes,
            true, // Safety checks on?
            Arrays.asList(10, 20, 30)  // RTD list.
        );
        return status;
    }

}
