/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.WriterProvider;
import org.lsst.ccs.utilities.structs.ParameterPath;

class ConfigurationWriterProvider {
    private final WriterProvider wp = WriterProvider.getInstance();
    private static final String GLOBAL_PREFIX = "configGlobal_";
    private final String providerName;
    private final ConfigurationService configService;
    public static boolean RETURN_FULL_PROPERTIES = false;

    ConfigurationWriterProvider(String providerName, ConfigurationService configurationService) {
        this.providerName = providerName;
        this.configService = configurationService;
        RETURN_FULL_PROPERTIES = System.getProperty("org.lsst.ccs.testcontext", "false").equals("true");
    }

    public PrintWriter getConfigurationWriter(String tagName, String categoryName) throws IOException {
        String newName = new ConfigurationFileName(this.providerName, tagName, categoryName).getFullName();
        return this.wp.getPrintWriter(newName);
    }

    public Properties getConfigurationProperties(String tagName, String categoryName) throws IOException {
        String newName = new ConfigurationFileName(this.providerName, tagName, categoryName).getFullName();
        Properties props = null;
        if (RETURN_FULL_PROPERTIES && this.configService != null && this.configService.defaultInitialDescription != null && this.configService.defaultInitialDescription.getCategoryTag(categoryName) != null && ((String)this.configService.defaultInitialDescription.getCategoryTag(categoryName).getTags().get(0)).equals(tagName) && this.configService.initialView != null) {
            props = new Properties();
            for (ConfigurationParameterHandler cph : this.configService.configurationHandler.getCategoryHandler(categoryName).getParameters()) {
                ParameterPath parPath = cph.getParameterPath();
                props.put(parPath.toString(), this.configService.initialView.getPathValue(parPath));
            }
        }
        Properties fileProps = this.wp.getProperties(newName);
        if (props != null) {
            if (fileProps != null) {
                props.putAll((Map<?, ?>)fileProps);
            }
            fileProps = props;
        }
        return fileProps;
    }

    public Set<String> findMatchingConfigurations(String category) {
        String pattern = this.providerName;
        pattern = category.isEmpty() ? pattern + "(_[^_]+?)??" : pattern + "_.*?_" + category;
        pattern = pattern + "\\.properties";
        Set fullNames = this.wp.findMatchingPropertiesFiles(pattern);
        return fullNames.stream().map(s -> new ConfigurationFileName(this.providerName, (String)s).configName).collect(Collectors.toSet());
    }

    public String getNamedConfiguration(String name) throws IOException {
        Properties props = this.wp.getProperties(GLOBAL_PREFIX + this.providerName);
        if (props != null) {
            return props.getProperty(name);
        }
        return null;
    }

    public void setNamedConfiguration(ConfigurationDescription configDesc) throws IOException {
        Properties props = this.wp.getProperties(GLOBAL_PREFIX + this.providerName);
        if (props == null) {
            props = new Properties();
        }
        props.put(configDesc.getName(), configDesc.toString());
        PrintWriter pw = this.wp.getPrintWriter(GLOBAL_PREFIX + this.providerName);
        for (String prop : props.stringPropertyNames()) {
            pw.println(prop + "=" + (String)props.get(prop));
        }
        pw.flush();
        pw.close();
    }

    public String locateConfiguration(String configName, String categoryName) {
        String fileName = new ConfigurationFileName(this.providerName, configName, categoryName).getFullName();
        return this.wp.locateFile(fileName);
    }

    public String getProviderName() {
        return this.providerName;
    }

    static class ConfigurationFileName {
        private final String tagName;
        private final String configName;
        private final String catName;
        private final String fullName;

        ConfigurationFileName(String tagName, String configName, String categoryName) {
            this.tagName = tagName;
            this.configName = configName;
            this.catName = categoryName;
            String baseName = tagName;
            if (configName.isEmpty()) {
                if (!this.catName.isEmpty()) {
                    baseName = baseName + "__" + this.catName;
                }
            } else {
                baseName = baseName + "_" + configName;
                if (!this.catName.isEmpty()) {
                    baseName = baseName + "_" + this.catName;
                }
            }
            this.fullName = baseName + ".properties";
        }

        ConfigurationFileName(String tagName, String fullName) {
            this.tagName = tagName;
            String trimmed = fullName.replace(".properties", "").replace(this.tagName, "");
            String[] split = trimmed.split("_");
            switch (split.length) {
                case 1: {
                    this.configName = "";
                    this.catName = "";
                    break;
                }
                case 2: {
                    this.configName = split[1];
                    this.catName = "";
                    break;
                }
                case 3: {
                    this.configName = split[1];
                    this.catName = split[2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException("file name is not a configuration file name : " + fullName);
                }
            }
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }
    }
}

