/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.util.Arrays;
import java.util.logging.Logger;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusAggregator;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusListener;
import org.lsst.ccs.messaging.AgentMessagingLayer;
import org.lsst.ccs.messaging.StatusMessageListener;
import org.lsst.ccs.subsystem.shutter.common.Constants;
import org.lsst.ccs.subsystem.shutter.common.PhysicalState;
import org.lsst.ccs.subsystem.shutter.common.SoftwareState;
import org.lsst.ccs.subsystem.shutter.gui.PluginActions;
import org.lsst.ccs.subsystem.shutter.gui.ShutterPlugin;
import org.lsst.ccs.subsystem.shutter.status.MotionDone;
import org.lsst.ccs.subsystem.shutter.status.ShutterStatus;

public class StatusListener
implements PluginActions,
AgentStatusListener,
StatusMessageListener {
    private static final Logger LOG = Logger.getLogger(StatusListener.class.getName());
    private final ShutterPlugin plugin;

    public StatusListener(ShutterPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void disconnect() {
        LOG.fine("disconnect()");
        AgentStatusAggregator agg = this.plugin.getConsole().getStatusAggregator();
        agg.removeListener((AgentStatusListener)this);
        AgentMessagingLayer aml = this.plugin.getConsole().getMessagingAccess();
        aml.removeStatusMessageListener((StatusMessageListener)this);
    }

    @Override
    public void connect() {
        LOG.fine("connect()");
        AgentStatusAggregator agg = this.plugin.getConsole().getStatusAggregator();
        agg.addListener((AgentStatusListener)this, Arrays.asList(this.plugin.getWorkerName()), null);
        AgentMessagingLayer aml = this.plugin.getConsole().getMessagingAccess();
        aml.addStatusMessageListener((StatusMessageListener)this, msg -> msg.getOriginAgentInfo().getName().equals(this.plugin.getWorkerName()));
    }

    public void disconnect(AgentStatusEvent event) {
        LOG.fine("Worker is offline.");
        this.plugin.getDispatcher().showWorkerIsUnreachable("OFFLINE");
    }

    public void connect(AgentStatusEvent event) {
        LOG.fine("Worker is online.");
        this.plugin.getDispatcher().showWorkerIsReachable();
    }

    public void onStatusMessage(StatusMessage msg) {
        LOG.fine(msg.toString());
        PhysicalState pstate = (PhysicalState)msg.getState().getComponentState(Constants.PHYSICAL_STATE_PATH, PhysicalState.class);
        SoftwareState sstate = (SoftwareState)msg.getState().getComponentState(Constants.SOFTWARE_STATE_PATH, SoftwareState.class);
        this.plugin.getDispatcher().showStateBundle(pstate, sstate);
        if (msg instanceof StatusSubsystemData) {
            StatusSubsystemData sd = (StatusSubsystemData)msg;
            String key = sd.getDataKey();
            if (key.equals(ShutterStatus.class.getSimpleName())) {
                ShutterStatus status = (ShutterStatus)sd.getSubsystemData().getValue();
                this.plugin.getDispatcher().showStatus(status);
            } else if (key.equals(MotionDone.class.getSimpleName())) {
                MotionDone status = (MotionDone)sd.getSubsystemData().getValue();
                this.plugin.getDispatcher().showTrajectory(status);
            }
        }
    }
}

