/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.shutter.gui;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.gconsole.agent.command.CommandTask;
import org.lsst.ccs.gconsole.services.command.CommandService;
import org.lsst.ccs.messaging.CommandRejectedException;
import org.lsst.ccs.subsystem.shutter.common.Axis;
import org.lsst.ccs.subsystem.shutter.common.ShutterSide;
import org.lsst.ccs.subsystem.shutter.gui.PluginActions;
import org.lsst.ccs.subsystem.shutter.gui.ShutterPlugin;

public class Commander
implements PluginActions {
    private static final Logger LOG = Logger.getLogger(Commander.class.getName());
    private final ShutterPlugin plugin;
    private final CommandService command;

    public Commander(ShutterPlugin plugin) {
        this.plugin = plugin;
        this.command = new CommandService();
    }

    @Override
    public void takeExposure(double exposureTime) {
        LOG.fine(() -> "takeExposure(" + exposureTime + ")");
        this.issueCommand("takeExposure", exposureTime);
    }

    @Override
    public void openShutter() {
        LOG.fine("openShutter()");
        this.issueCommand("openShutter", new Object[0]);
    }

    @Override
    public void closeShutter() {
        LOG.fine("closeShutter()");
        this.issueCommand("closeShutter", new Object[0]);
    }

    @Override
    public void changeBrakeState(ShutterSide side, boolean brakeEngaged) {
        LOG.fine(() -> String.format("changeBrakeState(%s, %s)", side, brakeEngaged));
        Axis axis = side == ShutterSide.PLUSX ? Axis.getPlusXSide() : Axis.getMinusXSide();
        this.issueCommand("changeBrakeState", axis.getName(), brakeEngaged);
    }

    @Override
    public void calibrate() {
        LOG.fine("calibrate()");
        this.issueCommand("calibrate", new Object[0]);
    }

    @Override
    public void toggleSafetyCheck() {
        LOG.fine("toggleSafetyCheck()");
        this.issueCommand("toggleSafetyCheck", new Object[0]);
    }

    @Override
    public void center() {
        LOG.fine("center()");
        this.issueCommand("gotoCenter", new Object[0]);
    }

    @Override
    public void prodMode() {
        LOG.fine("prodMode()");
        this.issueCommand("switchToNormalMode", new Object[0]);
    }

    @Override
    public void resync() {
        LOG.fine("resync()");
        this.issueCommand("resync", new Object[0]);
    }

    @Override
    public void stopMotion() {
        LOG.fine("stopMotion()");
        this.issueCommand("stopAll", new Object[0]);
    }

    private void issueCommand(String bareCmd, Object ... args) {
        try {
            String cmd = String.format("%s/%s", "cam-shutter", bareCmd);
            CommandTask task = this.command.execute(cmd, args);
            task.get();
        }
        catch (CancellationException exc) {
            this.plugin.getDispatcher().showCommandFailure("Commmand was canceled.");
        }
        catch (IllegalStateException exc) {
            String msg = String.format("Subsystem %s is offline.", "cam-shutter");
            LOG.warning(msg);
            this.plugin.getDispatcher().showWorkerIsUnreachable(msg);
        }
        catch (InterruptedException exc) {
            LOG.log(Level.WARNING, "Interrupted while awaiting a command response.", exc);
            this.plugin.getDispatcher().showCommandFailure("Interupted while awaitng a command response.");
        }
        catch (CommandRejectedException exc) {
            this.plugin.getDispatcher().showCommandFailure(exc.getMessage());
        }
        catch (TimeoutException exc) {
            this.plugin.getDispatcher().showCommandFailure("Command timed out.");
        }
        catch (ExecutionException exc) {
            this.plugin.getDispatcher().showCommandFailure("Command failed inside worker.");
        }
    }
}

