/*
 * Decompiled with CFR 0.152.
 */
package plotter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import menus.IncludeInMenu;
import menus.MenuUtils;
import org.freehep.swing.popup.HasPopupItems;
import plotter.AutoRangeAxisModel;
import plotter.AxisLabeler;
import plotter.AxisModel;
import plotter.ContinuousAxisModel;
import plotter.DefaultAxisLabeller;
import plotter.DiscreteAxisLabeller;
import plotter.DiscreteAxisModel;
import plotter.LabelRenderer;
import plotter.LabelSizer;
import plotter.LinearAxisModel;
import plotter.LogarithmicAxisLabeler;
import plotter.LogarithmicAxisModel;
import plotter.TestFrame;
import util.FontChooserPanel;

public class Axis
extends JComponent
implements HasPopupItems {
    private static final RenderingHints antiAlias = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    private static final int padAroundEdge = 2;
    private static final int padFromAxis = 2;
    private static final int padFromLabels = 2;
    private static final int majorTickLength = 4;
    private static final int minorTickLength = 2;
    private static final int lineWidth = 2;
    private AxisLabelSizer labelSizer = new AxisLabelSizer();
    private AxisLabeler labeler;
    private AxisModel model;
    private AxisPosition axisPosition;
    private Color axisColor = null;
    private Color axisOriginDotColor = null;
    private Color majorTickMarkColor = null;
    private Color minorTickMarkColor = null;
    private Color textColor = null;
    private boolean showLabels = true;
    private boolean parallelLabels = true;
    private boolean showOuterTicks = true;
    private boolean showInnerTicks = false;
    private String title;
    private boolean showTitle = true;
    private int axisLength;
    private int lowerOffset = 0;
    private int upperOffset = 0;
    private boolean layoutValid = false;
    private AxisTitle axisTitle = new AxisTitle();
    private AxisLabels axisLabels = new AxisLabels();
    private AxisLine axisLine = new AxisLine();
    private AxisMultiplier axisMultiplier = new AxisMultiplier();

    public Axis(AxisModel model, AxisPosition axisPosition) {
        this.model = model;
        model.addChangeListener(new ModelChangeListener());
        this.labeler = this.createLabelerForModel(model);
        this.setAxisOrientation(axisPosition);
        this.setToolTipText("");
        this.axisTitle.setVisible(false);
        this.axisMultiplier.setVisible(this.labeler.getAxisUnit() != null);
    }

    private AxisLabeler createLabelerForModel(AxisModel model) {
        if (model instanceof LogarithmicAxisModel) {
            return new LogarithmicAxisLabeler((LogarithmicAxisModel)model);
        }
        if (model instanceof ContinuousAxisModel) {
            return new DefaultAxisLabeller((ContinuousAxisModel)model, this.labelSizer);
        }
        if (model instanceof DiscreteAxisModel) {
            return new DiscreteAxisLabeller((DiscreteAxisModel)model);
        }
        throw new IllegalArgumentException("Unsupported model " + model);
    }

    public boolean isShowTitle() {
        return this.showTitle;
    }

    @IncludeInMenu(value="Show Axis Title")
    public void setShowTitle(boolean showAxisTitle) {
        this.showTitle = showAxisTitle;
        this.axisTitle.setVisible(this.title != null && this.title.length() > 0 && this.showTitle);
        this.revalidate();
    }

    public String getTitle() {
        return this.title;
    }

    @IncludeInMenu(value="Axis Title")
    public void setTitle(String title) {
        this.title = title;
        this.axisTitle.setVisible(title != null && title.length() > 0 && this.showTitle);
        this.revalidate();
        this.repaint();
    }

    public AxisPosition getAxisPosition() {
        return this.axisPosition;
    }

    @IncludeInMenu(value="Axis Color")
    public void setAxisColor(Color newColor) {
        this.axisColor = newColor;
        this.repaint();
    }

    public Color getAxisColor() {
        if (this.axisColor != null) {
            return this.axisColor;
        }
        return this.getForeground();
    }

    public void setAxisOriginDotColor(Color newColor) {
        this.axisOriginDotColor = newColor;
    }

    public Color getAxisOriginDotColor() {
        if (this.axisOriginDotColor != null) {
            return this.axisOriginDotColor;
        }
        return this.getAxisColor();
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        this.layoutValid = this.layoutValid && width == this.getWidth() && height == this.getHeight();
        super.setBounds(x, y, width, height);
        this.layoutValid = true;
        if (this.axisPosition.isVertical()) {
            width = this.getHeight();
            height = this.getWidth();
        }
        this.axisLength = width - 4;
        this.upperOffset = 0;
        this.lowerOffset = 0;
        if (this.axisLength > 0 && this.axisLabels.isVisible()) {
            this.labelSizer.sizeChanged();
            int n = this.labeler.getNLabels();
            this.axisMultiplier.setVisible(this.labeler.getAxisUnit() != null);
            if (n > 0) {
                String firstLabel = this.labeler.getLabel(0);
                float firstPos = this.labeler.getLabelPos(0);
                float offset = firstPos - this.labelSizer.getSize(firstLabel) / 2.0f;
                if (offset < 0.0f) {
                    this.lowerOffset = (int)Math.floor((float)(-this.axisLength) * offset);
                }
                String lastLabel = this.labeler.getLabel(n - 1);
                float lastPos = this.labeler.getLabelPos(n - 1);
                offset = lastPos + this.labelSizer.getSize(lastLabel) / 2.0f;
                if (offset > 1.0f) {
                    this.upperOffset = (int)Math.ceil((float)this.axisLength * (offset - 1.0f));
                }
                if (this.axisMultiplier.isVisible()) {
                    Dimension mSize = this.axisMultiplier.getPreferredSize();
                    this.upperOffset = (int)((double)this.upperOffset + (2.0 + mSize.getWidth()));
                }
                this.axisLength -= this.lowerOffset + this.upperOffset;
            }
        }
        float yPosition = this.axisPosition.isFlipped() ? (float)(height - this.axisLine.getPreferredSize().height) : 0.0f;
        int flipSign = this.axisPosition.isFlipped() ? -1 : 1;
        this.axisLine.setBounds(2 + this.lowerOffset, yPosition, this.axisLength, this.axisLine.getPreferredSize().height);
        if (!this.axisPosition.isFlipped()) {
            yPosition += this.axisLine.height;
        }
        if (this.axisLabels.isVisible()) {
            float yAxisLabel = yPosition + (float)(2 * flipSign);
            Dimension alSize = this.axisLabels.getPreferredSize();
            if (this.axisPosition.isFlipped()) {
                yAxisLabel -= (float)alSize.height;
            }
            this.axisLabels.setBounds(2.0f, yAxisLabel, this.axisLength + this.lowerOffset + this.upperOffset, alSize.height);
            if (this.axisMultiplier.isVisible()) {
                float yAxisMultiplier = yPosition + (float)(2 * flipSign);
                Dimension axSize = this.axisMultiplier.getPreferredSize();
                if (this.axisPosition.isFlipped()) {
                    yAxisMultiplier -= (float)axSize.height;
                }
                this.axisMultiplier.setBounds(2 + this.axisLength + this.lowerOffset + this.upperOffset - axSize.width, yAxisMultiplier, this.upperOffset, axSize.height);
                yPosition += (float)flipSign * Math.max(this.axisLabels.height, this.axisMultiplier.height);
            } else {
                yPosition += (float)flipSign * this.axisLabels.height;
            }
        }
        if (this.axisTitle.isVisible()) {
            yPosition += (float)(2 * flipSign);
            if (this.axisPosition.isFlipped()) {
                yPosition -= (float)this.axisTitle.getPreferredSize().height;
            }
            this.axisTitle.setBounds(2 + this.lowerOffset, yPosition, this.axisLength, this.axisTitle.getPreferredSize().height);
        }
    }

    boolean isHappy() {
        Dimension size = this.getPreferredSize();
        return this.axisPosition.isVertical() ? this.getWidth() >= size.width : this.getHeight() >= size.height;
    }

    public Point getEndPoint() {
        Point2D.Float p = this.axisLine.getEndPoint();
        return this.axisPosition.isVertical() ? new Point((int)p.y, this.getHeight() - (int)p.x) : new Point((int)p.x, (int)p.y);
    }

    public Point getStartPoint() {
        Point2D.Float p = this.axisLine.getStartPoint();
        return this.axisPosition.isVertical() ? new Point((int)p.y, this.getHeight() - (int)p.x) : new Point((int)p.x, (int)p.y);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.revalidate();
    }

    public AxisLabeler getLabeler() {
        return this.labeler;
    }

    public void setLabeler(AxisLabeler labeler) {
        this.labeler = labeler;
    }

    public void setMajorTickMarkColor(Color newColor) {
        this.majorTickMarkColor = newColor;
    }

    public Color getMajorTickMarkColor() {
        if (this.majorTickMarkColor != null) {
            return this.majorTickMarkColor;
        }
        return this.getAxisColor();
    }

    public void setMinorTickMarkColor(Color newColor) {
        this.minorTickMarkColor = newColor;
    }

    public Color getMinorTickMarkColor() {
        if (this.minorTickMarkColor != null) {
            return this.minorTickMarkColor;
        }
        return this.getAxisColor();
    }

    public boolean isParallelLabels() {
        return this.parallelLabels;
    }

    @IncludeInMenu(value="Parallel Labels")
    public void setParallelLabels(boolean parallelLabels) {
        this.parallelLabels = parallelLabels;
        this.revalidate();
        this.repaint();
    }

    public void setModel(AxisModel model) {
        this.model = model;
        this.labeler = new DefaultAxisLabeller((ContinuousAxisModel)model, this.labelSizer);
        this.axisMultiplier.setVisible(this.labeler.getAxisUnit() != null);
        this.revalidate();
    }

    public AxisModel getModel() {
        return this.model;
    }

    public double getPhysicalCoordinateFromAxisCoordinate(double x, Component target) {
        double result = (double)(this.lowerOffset + 2) + x * (double)this.axisLength;
        if (this.axisPosition.isVertical()) {
            result = (double)this.getHeight() - result;
        }
        if (target == null || target == this) {
            return result;
        }
        if (target.getParent() == this.getParent()) {
            if (this.axisPosition.isVertical()) {
                return result - (double)target.getY() + (double)this.getY();
            }
            return result - (double)target.getX() + (double)this.getX();
        }
        throw new RuntimeException("Too horrible to contemplate");
    }

    @Override
    public Dimension getPreferredSize() {
        int width = 300;
        int height = 2;
        height += this.axisLine.getPreferredSize().height;
        if (this.axisLabels.isVisible()) {
            int h1 = this.axisLabels.getPreferredSize().height + 2;
            int h2 = this.axisMultiplier.isVisible() ? this.axisMultiplier.getPreferredSize().height + 2 : 0;
            height += Math.max(h1, h2);
        }
        if (this.axisTitle.isVisible()) {
            height += this.axisTitle.getPreferredSize().height + 2;
        }
        if (this.axisPosition.isVertical()) {
            return new Dimension(height, width);
        }
        return new Dimension(width, height);
    }

    @IncludeInMenu(value="Show Inner Ticks")
    public void setShowInnerTicks(boolean showInnerTicks) {
        this.showInnerTicks = showInnerTicks;
        this.revalidate();
        this.repaint();
    }

    public boolean isShowInnerTicks() {
        return this.showInnerTicks;
    }

    @IncludeInMenu(value="Show Axis Labels")
    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
        this.axisLabels.setVisible(showLabels);
        this.revalidate();
    }

    public boolean isShowLabels() {
        return this.showLabels;
    }

    @IncludeInMenu(value="Show Outer Ticks")
    public void setShowOuterTicks(boolean showOuterTicks) {
        this.showOuterTicks = showOuterTicks;
        this.revalidate();
        this.repaint();
    }

    public boolean isShowOuterTicks() {
        return this.showOuterTicks;
    }

    public void setTextColor(Color newColor) {
        this.textColor = newColor;
        this.repaint();
    }

    public Color getTextColor() {
        if (this.textColor != null) {
            return this.textColor;
        }
        return this.getAxisColor();
    }

    @Override
    public String getToolTipText(MouseEvent me) {
        float x;
        Component c = me.getComponent();
        Point p = me.getPoint();
        if (c != this) {
            p = SwingUtilities.convertPoint(c, p, this);
        }
        float f = x = this.axisPosition.isVertical() ? (float)(this.getHeight() - p.y) : (float)p.x;
        if (x < (float)(2 + this.lowerOffset) || x > (float)(2 + this.lowerOffset + this.axisLength)) {
            return null;
        }
        x = (x - 2.0f - (float)this.lowerOffset) / (float)this.axisLength;
        return this.labeler.getToolTipText(x);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component source, Point p) {
        MenuUtils.buildMenu(menu, this);
        JMenuItem font = new JMenuItem("Axis Font..."){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                FontChooserPanel fp = new FontChooserPanel(Axis.this.getFont());
                int rc = JOptionPane.showConfirmDialog(Axis.this, fp, "Select Font...", 2, -1);
                if (rc == 0) {
                    Axis.this.setFont(fp.getSelectedFont());
                }
            }
        };
        font.setMnemonic('F');
        menu.add(font);
        if (this.model instanceof HasPopupItems) {
            menu = ((HasPopupItems)this.model).modifyPopupMenu(menu, source, p);
        }
        return menu;
    }

    protected final void setAxisOrientation(AxisPosition pos) {
        if (this.axisPosition != pos) {
            this.axisPosition = pos;
            this.setParallelLabels(!this.axisPosition.isVertical());
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(antiAlias);
        if (this.axisPosition.isVertical()) {
            g2.rotate(-1.5707963267948966);
            g2.translate(-this.getHeight(), 0);
        }
        this.axisLine.paint(g2);
        this.axisLabels.paint(g2);
        this.axisTitle.paint(g2);
        if (this.axisLabels.isVisible()) {
            this.axisMultiplier.paint(g2);
        }
    }

    LabelSizer getLabelSizer() {
        return this.labelSizer;
    }

    void nudgeStartAndEndPoint(int start, int end) {
        this.lowerOffset = start - 2;
        this.upperOffset = end - 2;
        this.axisLength = this.axisPosition.isVertical() ? this.getHeight() - start - end : this.getWidth() - start - end;
        this.axisLine.setBounds(2 + this.lowerOffset, this.axisLine.y, this.axisLength, this.axisLine.height);
        if (this.axisTitle.isVisible()) {
            this.axisTitle.setBounds(2 + this.lowerOffset, this.axisTitle.y, this.axisLength, this.axisTitle.height);
        }
    }

    void clearNudge() {
        this.layoutValid = false;
    }

    public static void main(String[] args) {
        final LinearAxisModel model = new LinearAxisModel(0.0, 10.0);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new Axis(model, AxisPosition.TOP));
        panel.add(new Axis(new AutoRangeAxisModel(model), AxisPosition.TOP));
        final JSlider slider = new JSlider();
        slider.setMinimum(1);
        slider.setMaximum(100);
        panel.add(slider);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                model.setMax(slider.getValue());
            }
        });
        new TestFrame("Axis Test", panel);
    }

    private abstract class AxisComponent {
        float width;
        float height;
        float x;
        float y;
        private boolean visible = true;

        private AxisComponent() {
        }

        abstract Dimension getPreferredSize();

        void paint(Graphics2D g2) {
            if (this.isVisible()) {
                g2.translate(this.x, this.y);
                this.paintComponent(g2);
                g2.translate(-this.x, -this.y);
            }
        }

        abstract void paintComponent(Graphics2D var1);

        void setBounds(float x, float y, float width, float height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        boolean isVisible() {
            return this.visible;
        }

        void setVisible(boolean isVisible) {
            this.visible = isVisible;
        }
    }

    private class AxisTitle
    extends AxisComponent {
        private AxisTitle() {
        }

        @Override
        void paintComponent(Graphics2D g2) {
            FontMetrics fm = g2.getFontMetrics();
            Rectangle2D bounds = fm.getStringBounds(Axis.this.title, g2);
            float xText = (this.width - (float)bounds.getWidth()) / 2.0f;
            g2.drawString(Axis.this.title, xText, (float)fm.getAscent());
        }

        @Override
        Dimension getPreferredSize() {
            FontMetrics fm = Axis.this.getFontMetrics(Axis.this.getFont());
            return new Dimension(fm.stringWidth(Axis.this.title), fm.getHeight());
        }
    }

    private class AxisMultiplier
    extends AxisComponent {
        private AxisMultiplier() {
        }

        @Override
        Dimension getPreferredSize() {
            LabelRenderer renderer = new LabelRenderer(Axis.this.getFontMetrics(Axis.this.getFont()));
            if (Axis.this.parallelLabels) {
                return new Dimension((int)renderer.getWidth(Axis.this.labeler.getAxisUnit()), (int)renderer.getHeight(Axis.this.labeler.getAxisUnit()));
            }
            return new Dimension((int)renderer.getHeight(Axis.this.labeler.getAxisUnit()), (int)renderer.getWidth(Axis.this.labeler.getAxisUnit()));
        }

        @Override
        void paintComponent(Graphics2D g2) {
            LabelRenderer renderer = new LabelRenderer(Axis.this.getFontMetrics(Axis.this.getFont()));
            String unit = Axis.this.labeler.getAxisUnit();
            if (Axis.this.parallelLabels) {
                renderer.render(g2, 0.0f, renderer.getAscent(unit), unit);
            } else {
                g2.rotate(1.5707963267948966);
                float xOff = Axis.this.axisPosition.isFlipped() ? this.height - renderer.getWidth(unit) : 0.0f;
                renderer.render(g2, xOff, 0.0f, unit);
                g2.rotate(-1.5707963267948966);
            }
        }
    }

    private class AxisLabels
    extends AxisComponent {
        private AxisLabels() {
        }

        @Override
        void paintComponent(Graphics2D g2) {
            g2.setColor(Axis.this.textColor);
            FontMetrics fm = g2.getFontMetrics();
            LabelRenderer renderer = new LabelRenderer(fm);
            int n = Axis.this.labeler.getNLabels();
            for (int i = 0; i < n; ++i) {
                String label = Axis.this.labeler.getLabel(i);
                float xText = (float)Axis.this.lowerOffset + (float)Axis.this.axisLength * Axis.this.labeler.getLabelPos(i);
                if (Axis.this.parallelLabels) {
                    renderer.render(g2, xText - renderer.getWidth(label) / 2.0f, renderer.getAscent(label), label);
                    continue;
                }
                g2.translate(xText, 0.0);
                g2.rotate(1.5707963267948966);
                float xOff = Axis.this.axisPosition.isFlipped() ? this.height - renderer.getWidth(label) : 0.0f;
                renderer.render(g2, xOff, (renderer.getAscent(label) - renderer.getDescent(label)) / 2.0f, label);
                g2.rotate(-1.5707963267948966);
                g2.translate(-xText, 0.0);
            }
        }

        @Override
        Dimension getPreferredSize() {
            float labelHeight;
            Font font = Axis.this.getFont();
            FontMetrics fm = Axis.this.getFontMetrics(font);
            LabelRenderer renderer = new LabelRenderer(fm);
            if (Axis.this.parallelLabels) {
                labelHeight = renderer.getHeight(Axis.this.labeler.getLabel(0));
            } else {
                int n = Axis.this.labeler.getNLabels();
                float maxHeight = 0.0f;
                for (int i = 0; i < n; ++i) {
                    String label = Axis.this.labeler.getLabel(i);
                    float labelWidth = renderer.getWidth(label);
                    if (!(labelWidth > maxHeight)) continue;
                    maxHeight = labelWidth;
                }
                labelHeight = maxHeight;
            }
            return new Dimension(300, (int)labelHeight);
        }
    }

    private class AxisLine
    extends AxisComponent {
        private AxisLine() {
        }

        @Override
        Dimension getPreferredSize() {
            int axisHeight = 2;
            if (Axis.this.showOuterTicks) {
                axisHeight += 4;
            }
            if (Axis.this.showInnerTicks) {
                axisHeight += 4;
            }
            return new Dimension(300, axisHeight);
        }

        Point2D.Float getEndPoint() {
            return new Point2D.Float(this.x + (float)Axis.this.axisLength, this.y + (float)((Axis.this.axisPosition.isFlipped() ? Axis.this.showOuterTicks : Axis.this.showInnerTicks) ? 4 : 0) + 1.0f);
        }

        Point2D.Float getStartPoint() {
            return new Point2D.Float(this.x, this.y + (float)((Axis.this.axisPosition.isFlipped() ? Axis.this.showOuterTicks : Axis.this.showInnerTicks) ? 4 : 0) + 1.0f);
        }

        @Override
        void paintComponent(Graphics2D g2) {
            BasicStroke stroke = new BasicStroke(2.0f, 0, 2);
            g2.setStroke(stroke);
            g2.setColor(Axis.this.axisColor);
            float yLine = 1.0f + (float)((Axis.this.axisPosition.isFlipped() ? Axis.this.showOuterTicks : Axis.this.showInnerTicks) ? 4 : 0);
            Line2D.Float line = new Line2D.Float();
            line.setLine(0.0f, yLine, this.width, yLine);
            g2.draw(line);
            if (Axis.this.showOuterTicks || Axis.this.showInnerTicks) {
                float xTick;
                int i;
                g2.setColor(Axis.this.majorTickMarkColor);
                int n = Axis.this.labeler.getNTickMarks();
                float y1 = 0.0f;
                float y2 = 2 + (Axis.this.showInnerTicks ? 4 : 0) + (Axis.this.showOuterTicks ? 4 : 0);
                for (i = 0; i < n; ++i) {
                    xTick = (float)Axis.this.axisLength * Axis.this.labeler.getTickPos(i);
                    line.setLine(xTick, y1, xTick, y2);
                    g2.draw(line);
                }
                g2.setColor(Axis.this.minorTickMarkColor);
                n = Axis.this.labeler.getNMinorTickMarks();
                y1 = (Axis.this.axisPosition.isFlipped() ? Axis.this.showOuterTicks : Axis.this.showInnerTicks) ? 2.0f : 0.0f;
                y2 = y1 + 2.0f + (float)(Axis.this.showInnerTicks ? 2 : 0) + (float)(Axis.this.showOuterTicks ? 2 : 0);
                for (i = 0; i < n; ++i) {
                    xTick = (float)Axis.this.axisLength * Axis.this.labeler.getMinorTickPos(i);
                    line.setLine(xTick, y1, xTick, y2);
                    g2.draw(line);
                }
            }
        }
    }

    private class AxisLabelSizer
    implements LabelSizer {
        private FontRenderContext frc = new FontRenderContext(null, false, false);

        private AxisLabelSizer() {
        }

        @Override
        public float getSize(String xxx) {
            Font f = Axis.this.getFont();
            Rectangle2D r = f.getStringBounds(xxx, this.frc);
            double width = r.getWidth();
            return (float)width / (float)Axis.this.axisLength;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
            Axis.this.listenerList.add(ChangeListener.class, l);
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
            Axis.this.listenerList.remove(ChangeListener.class, l);
        }

        void sizeChanged() {
            int n = Axis.this.listenerList.getListenerCount(ChangeListener.class);
            if (n > 0) {
                ChangeEvent event = new ChangeEvent(Axis.this);
                ChangeListener[] list = (ChangeListener[])Axis.this.listenerList.getListeners(ChangeListener.class);
                int i = list.length;
                while (i > 0) {
                    list[--i].stateChanged(event);
                }
            }
        }
    }

    private class ModelChangeListener
    implements ChangeListener {
        private ModelChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Axis.this.revalidate();
            Axis.this.repaint();
        }
    }

    public static enum AxisPosition {
        BOTTOM(false, false),
        TOP(false, true),
        LEFT(true, true),
        RIGHT(true, false);

        private boolean vertical;
        private boolean flipped;

        private AxisPosition(boolean vertical, boolean flipped) {
            this.vertical = vertical;
            this.flipped = flipped;
        }

        boolean isFlipped() {
            return this.flipped;
        }

        boolean isVertical() {
            return this.vertical;
        }
    }
}

